/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app.config;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import pl.fhframework.app.config.FhApplicationConfiguration;
import pl.fhframework.app.config.FhNavbarConfiguration;

@Configuration
public class DefaultApplicationConfigurer {
    @Autowired(required=false)
    private FhApplicationConfiguration configuration;
    @Autowired(required=false)
    private FhNavbarConfiguration navbarConfiguration;
    private Map<String, String> cssUrls;

    @PostConstruct
    public void config() {
        if (this.configuration != null) {
            if (this.configuration.additionalCssUrl() != null) {
                System.setProperty("fh.application.css.url", this.configuration.additionalCssUrl());
            }
            if (this.configuration.additionalJsUrl() != null) {
                System.setProperty("fh.application.js.url", this.configuration.additionalJsUrl());
            }
            if (this.configuration.applicationTitle() != null) {
                System.setProperty("fh.application.title", this.configuration.applicationTitle());
            }
            if (this.configuration.applicationLogoUrl() != null) {
                System.setProperty("fh.application.logo.url", this.configuration.applicationLogoUrl());
            }
            if (Objects.equals(Boolean.TRUE, this.configuration.isMenuHidden())) {
                System.setProperty("fh.application.menu.hide", "true");
            }
        }
        this.cssUrls = this.getDefaultCssUrls();
        if (this.navbarConfiguration != null) {
            this.cssUrls = this.navbarConfiguration.bootstrapCssUrlList(this.cssUrls);
            if (this.navbarConfiguration.defaultCss() != null) {
                System.setProperty("fh.application.default.css", this.navbarConfiguration.defaultCss());
            }
        }
    }

    public Map<String, String> getCssUrls() {
        return this.cssUrls;
    }

    private Map<String, String> getDefaultCssUrls() {
        LinkedHashMap<String, String> cssUrls = new LinkedHashMap<String, String>();
        cssUrls.put("fh", null);
        cssUrls.put("materia", null);
        cssUrls.put("default", null);
        cssUrls.put("sketchy", String.format("https://bootswatch.com/4/%s/bootstrap.css", "sketchy"));
        cssUrls.put("cyborg", String.format("https://bootswatch.com/4/%s/bootstrap.css", "cyborg"));
        cssUrls.put("cosmo", String.format("https://bootswatch.com/4/%s/bootstrap.css", "cosmo"));
        cssUrls.put("superhero", String.format("https://bootswatch.com/4/%s/bootstrap.css", "superhero"));
        cssUrls.put("lux", String.format("https://bootswatch.com/4/%s/bootstrap.css", "lux"));
        return cssUrls;
    }
}

