/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import pl.fhframework.ReflectionUtils;
import pl.fhframework.app.config.FhApplication;
import pl.fhframework.config.PackagesScanConfiguration;
import pl.fhframework.core.FhFrameworkException;
import pl.fhframework.core.io.FhResource;
import pl.fhframework.core.logging.FhLogger;
import pl.fhframework.core.util.JsonUtil;
import pl.fhframework.subsystems.ModuleRegistry;

@FhApplication
public class DefaultApplication
extends SpringBootServletInitializer {
    private static final String SPRING_SCAN_CONFIGURATION_FILE_PATH = "packagesScanConfiguration.json";

    public static void main(String ... args) {
        DefaultApplication.fhApplicationInit();
        SpringApplication.run(DefaultApplication.class, (String[])args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        DefaultApplication.fhApplicationInit();
        return super.configure(builder);
    }

    public static void fhApplicationInit() {
        DefaultApplication.registerModules();
        DefaultApplication.preConfigureSpring();
    }

    protected static void registerModules() {
        ModuleRegistry.registry().autodetect().load();
    }

    protected static void preConfigureSpring() {
        String property;
        List basePackages = ModuleRegistry.getLoadedModules().stream().map(subsystem -> subsystem.getBasePackage()).collect(Collectors.toList());
        String componentsProperty = property = basePackages.stream().collect(Collectors.joining(","));
        String repositoriesProperty = property;
        String entitiesProperty = property;
        ClassPathScanningCandidateComponentProvider classPathScanner = new ClassPathScanningCandidateComponentProvider(false);
        classPathScanner.addIncludeFilter((TypeFilter)new AssignableTypeFilter(PackagesScanConfiguration.class));
        for (String basePackage : basePackages) {
            List packagesConfigClasses = ReflectionUtils.giveClassesTypeList((String)basePackage, PackagesScanConfiguration.class);
            for (Class clazz : packagesConfigClasses) {
                PackagesScanConfiguration scanConfiguration = (PackagesScanConfiguration)ReflectionUtils.createClassObject((Class)clazz);
                componentsProperty = DefaultApplication.joinPackages(componentsProperty, DefaultApplication.joinPackages(scanConfiguration.additionalComponentPackages()));
                repositoriesProperty = DefaultApplication.joinPackages(repositoriesProperty, DefaultApplication.joinPackages(scanConfiguration.additionalRepositoryPackages()));
                entitiesProperty = DefaultApplication.joinPackages(entitiesProperty, DefaultApplication.joinPackages(scanConfiguration.additionalEntityPackages()));
            }
        }
        PackagesScan additionalPackagesScan = DefaultApplication.readPackagesScan();
        componentsProperty = DefaultApplication.joinPackages(componentsProperty, DefaultApplication.joinPackages(additionalPackagesScan.getComponentPackages().toArray(new String[0])));
        repositoriesProperty = DefaultApplication.joinPackages(repositoriesProperty, DefaultApplication.joinPackages(additionalPackagesScan.getRepositoryPackages().toArray(new String[0])));
        entitiesProperty = DefaultApplication.joinPackages(entitiesProperty, DefaultApplication.joinPackages(additionalPackagesScan.getEntityPackages().toArray(new String[0])));
        System.setProperty("fh.component.scan", DefaultApplication.joinPackages(componentsProperty, System.getProperty("fh.component.scan")));
        System.setProperty("fh.repository.scan", DefaultApplication.joinPackages(repositoriesProperty, System.getProperty("fh.repository.scan")));
        System.setProperty("fh.entity.scan", DefaultApplication.joinPackages(entitiesProperty, System.getProperty("fh.entity.scan")));
    }

    private static String joinPackages(String ... packages) {
        return Arrays.stream(packages).filter(Objects::nonNull).collect(Collectors.joining(","));
    }

    protected static PackagesScan readPackagesScan() {
        PackagesScan additionalPackagesScan = new PackagesScan();
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        ArrayList<Resource> resources = new ArrayList<Resource>();
        try {
            resources.addAll(Arrays.asList(resolver.getResources("classpath*:packagesScanConfiguration.json")));
            for (Resource moduleResource : resources) {
                PackagesScan packagesScan = (PackagesScan)JsonUtil.readValue((String)new String(FhResource.get((Resource)moduleResource).getContent()), PackagesScan.class);
                additionalPackagesScan.getComponentPackages().addAll(packagesScan.getComponentPackages());
                additionalPackagesScan.getRepositoryPackages().addAll(packagesScan.getRepositoryPackages());
                additionalPackagesScan.getEntityPackages().addAll(packagesScan.getEntityPackages());
            }
        }
        catch (IOException exception) {
            FhLogger.error((String)"Cannot load Spring scan configuration", (Throwable)exception);
            throw new FhFrameworkException((Throwable)exception);
        }
        return additionalPackagesScan;
    }

    protected static class PackagesScan {
        List<String> componentPackages = new ArrayList<String>();
        List<String> repositoryPackages = new ArrayList<String>();
        List<String> entityPackages = new ArrayList<String>();

        public List<String> getComponentPackages() {
            return this.componentPackages;
        }

        public List<String> getRepositoryPackages() {
            return this.repositoryPackages;
        }

        public List<String> getEntityPackages() {
            return this.entityPackages;
        }

        public void setComponentPackages(List<String> componentPackages) {
            this.componentPackages = componentPackages;
        }

        public void setRepositoryPackages(List<String> repositoryPackages) {
            this.repositoryPackages = repositoryPackages;
        }

        public void setEntityPackages(List<String> entityPackages) {
            this.entityPackages = entityPackages;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PackagesScan)) {
                return false;
            }
            PackagesScan other = (PackagesScan)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$componentPackages = this.getComponentPackages();
            List<String> other$componentPackages = other.getComponentPackages();
            if (this$componentPackages == null ? other$componentPackages != null : !((Object)this$componentPackages).equals(other$componentPackages)) {
                return false;
            }
            List<String> this$repositoryPackages = this.getRepositoryPackages();
            List<String> other$repositoryPackages = other.getRepositoryPackages();
            if (this$repositoryPackages == null ? other$repositoryPackages != null : !((Object)this$repositoryPackages).equals(other$repositoryPackages)) {
                return false;
            }
            List<String> this$entityPackages = this.getEntityPackages();
            List<String> other$entityPackages = other.getEntityPackages();
            return !(this$entityPackages == null ? other$entityPackages != null : !((Object)this$entityPackages).equals(other$entityPackages));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PackagesScan;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $componentPackages = this.getComponentPackages();
            result = result * 59 + ($componentPackages == null ? 43 : ((Object)$componentPackages).hashCode());
            List<String> $repositoryPackages = this.getRepositoryPackages();
            result = result * 59 + ($repositoryPackages == null ? 43 : ((Object)$repositoryPackages).hashCode());
            List<String> $entityPackages = this.getEntityPackages();
            result = result * 59 + ($entityPackages == null ? 43 : ((Object)$entityPackages).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultApplication.PackagesScan(componentPackages=" + this.getComponentPackages() + ", repositoryPackages=" + this.getRepositoryPackages() + ", entityPackages=" + this.getEntityPackages() + ")";
        }
    }
}

