/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.app.preferences;

import java.util.HashMap;
import org.apache.commons.configuration2.ex.ConfigurationException;
import pl.fhframework.UserSession;
import pl.fhframework.annotations.Action;
import pl.fhframework.app.preferences.UserPreferencesForm;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.core.preferences.UserPreferencesEnum;
import pl.fhframework.core.preferences.UserPreferencesService;
import pl.fhframework.core.uc.IUseCaseNoCallback;
import pl.fhframework.core.uc.IUseCaseNoInput;
import pl.fhframework.core.uc.UseCase;
import pl.fhframework.events.BreakLevelEnum;
import pl.fhframework.model.forms.messages.Messages;

@UseCase
public class UserPreferencesUC
implements IUseCaseNoInput<IUseCaseNoCallback> {
    private UserPreferencesForm.Model model = new UserPreferencesForm.Model();
    private final UserPreferencesService preferencesService;
    private final MessageService messageService;

    public UserPreferencesUC(UserPreferencesService preferencesService, MessageService messageService) {
        this.preferencesService = preferencesService;
        this.messageService = messageService;
    }

    public void start() {
        try {
            this.model.setUseDefaultPrefs(this.preferencesService.getBooleanPreference(UserPreferencesEnum.USE_DEFAULTS_PREF.getKey(), true));
            this.model.setDesignerWidth(this.preferencesService.getIntPreference(UserPreferencesEnum.DESIGNER_WIDTH_PREF.getKey(), 1));
            this.model.setHideInnerPaddings(this.preferencesService.getBooleanPreference(UserPreferencesEnum.HIDE_INNER_PADDING_PREF.getKey(), false));
            this.model.setEditActiveElement(this.preferencesService.getBooleanPreference(UserPreferencesEnum.EDIT_ACTIVE_ELEMENT_PREF.getKey(), false));
            this.model.setFilterOutRowFromToolbox(this.preferencesService.getBooleanPreference(UserPreferencesEnum.FILTER_OUT_ROW_FROM_TOOLBOX_PREF.getKey(), false));
        }
        catch (ConfigurationException e) {
            Messages.showErrorMessage((UserSession)this.getUserSession(), (String)this.$("fh.preferences.messages.read.error"), (Throwable)e);
        }
        this.showForm(UserPreferencesForm.class, this.model);
    }

    @Action
    public void save() {
        try {
            if (this.model.isUseDefaultPrefs()) {
                this.preferencesService.clearPreferences();
            } else {
                HashMap<String, Comparable<Boolean>> preferences = new HashMap<String, Comparable<Boolean>>();
                preferences.put(UserPreferencesEnum.USE_DEFAULTS_PREF.getKey(), Boolean.valueOf(false));
                preferences.put(UserPreferencesEnum.DESIGNER_WIDTH_PREF.getKey(), Integer.valueOf(this.model.getDesignerWidth()));
                preferences.put(UserPreferencesEnum.HIDE_INNER_PADDING_PREF.getKey(), Boolean.valueOf(this.model.isHideInnerPaddings()));
                preferences.put(UserPreferencesEnum.EDIT_ACTIVE_ELEMENT_PREF.getKey(), Boolean.valueOf(this.model.isEditActiveElement()));
                preferences.put(UserPreferencesEnum.FILTER_OUT_ROW_FROM_TOOLBOX_PREF.getKey(), Boolean.valueOf(this.model.isFilterOutRowFromToolbox()));
                this.preferencesService.setPreferences(preferences);
            }
            Messages.showInfoMessage((UserSession)this.getUserSession(), (String)this.$("fh.preferences.messages.save.success"));
            this.exit();
        }
        catch (ConfigurationException e) {
            Messages.showErrorMessage((UserSession)this.getUserSession(), (String)this.$("fh.preferences.messages.save.error"), (Throwable)e);
        }
    }

    @Action(breakOnErrors=BreakLevelEnum.NEVER)
    public void cancel() {
        this.exit();
    }

    private String $(String key) {
        return this.messageService.getAllBundles().getMessage(key);
    }
}

