/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.util.StringUtils;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.Control;
import pl.fhframework.annotations.DesignerControl;
import pl.fhframework.annotations.DesignerXMLProperty;
import pl.fhframework.annotations.DocumentedComponent;
import pl.fhframework.annotations.DocumentedComponentAttribute;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ActionBinding;
import pl.fhframework.binding.CallbackActionBinding;
import pl.fhframework.binding.IActionCallback;
import pl.fhframework.binding.IActionCallbackContext;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.InMessageEventData;
import pl.fhframework.model.forms.Column;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.Group;
import pl.fhframework.model.forms.Iconable;
import pl.fhframework.model.forms.PanelGroup;
import pl.fhframework.model.forms.Repeater;
import pl.fhframework.model.forms.Row;
import pl.fhframework.model.forms.Tab;
import pl.fhframework.model.forms.Table;
import pl.fhframework.model.forms.TableComponent;
import pl.fhframework.model.forms.attribute.IconAlignment;
import pl.fhframework.model.forms.designer.BindingExpressionDesignerPreviewProvider;
import pl.fhframework.model.forms.optimized.ColumnOptimized;
import pl.fhframework.tools.loading.IBodyXml;

@TemplateControl(tagName="fh-output-label")
@Control(parents={PanelGroup.class, Column.class, ColumnOptimized.class, Tab.class, Row.class, Form.class, Repeater.class, Group.class}, invalidParents={Table.class}, canBeDesigned=true)
@DocumentedComponent(category=DocumentedComponent.Category.INPUTS_AND_VALIDATION, documentationExample=true, value="Label component is responsible for displaying value.", icon="fa fa-font")
@DesignerControl(defaultWidth=2)
public class OutputLabel
extends FormElement
implements TableComponent<OutputLabel>,
Iconable,
IBodyXml {
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_ON_CLICK = "onClick";
    private static final String FORMATTER_ATTR = "formatter";
    private static final String ICON_ATTR = "icon";
    @JsonIgnore
    @XMLProperty(value="icon")
    @DocumentedComponentAttribute(boundable=true, value="Icon id. Please refer to http://fontawesome.io/icons/ for all available icons.")
    @DesignerXMLProperty(priority=83, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    private ModelBinding<String> iconBinding;
    private String icon;
    @XMLProperty(defaultValue="before")
    @DesignerXMLProperty(priority=84, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.LOOK_AND_STYLE)
    @DocumentedComponentAttribute(defaultValue="before", boundable=true, value="Icon alignment - possible values are before or after. Final alignment depends of component where this attribute is used.")
    private IconAlignment iconAlignment;
    private String value;
    @JsonIgnore
    @XMLProperty(required=true, value="value")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.CONTENT, previewValueProvider=BindingExpressionDesignerPreviewProvider.class, priority=95)
    @DocumentedComponentAttribute(boundable=true, value="Represents text value for created component.")
    private ModelBinding valueBinding;
    @JsonIgnore
    @XMLProperty(value="formatter")
    @DocumentedComponentAttribute(value="Id of formatter which will format object to String. It must be consistent with value of pl.fhframework.formatter.FhFormatter annotation.")
    @DesignerXMLProperty(functionalArea=DesignerXMLProperty.PropertyFunctionalArea.SPECIFIC, priority=90)
    private String formatter;
    @XMLProperty
    @DesignerXMLProperty(commonUse=true, functionalArea=DesignerXMLProperty.PropertyFunctionalArea.BEHAVIOR, priority=90)
    @DocumentedComponentAttribute(value="If the label is clicked that method will be executed. Action is fired, while component is active.")
    private ActionBinding onClick;

    public OutputLabel(Form form) {
        super(form);
    }

    public void init() {
        super.init();
        this.calculateAndSetDefaultSize();
    }

    private void calculateAndSetDefaultSize() {
        if (!StringUtils.hasText((String)this.getWidth())) {
            this.setWidth(null);
        }
    }

    public ElementChanges updateView() {
        ElementChanges elementChanges = super.updateView();
        this.processValue(elementChanges);
        return elementChanges;
    }

    private void processValue(ElementChanges elementChanges) {
        String newLabelValue;
        BindingResult bindingResult;
        BindingResult bindingResult2 = bindingResult = this.valueBinding != null ? this.valueBinding.getBindingResult() : null;
        if (bindingResult != null && !this.areValuesTheSame(newLabelValue = this.convertValueToString(bindingResult.getValue(), this.formatter), this.value)) {
            this.refreshView();
            this.value = newLabelValue;
            elementChanges.addChange(ATTR_VALUE, (Object)this.value);
        }
        if (this.iconBinding != null) {
            this.icon = this.resolveIconBinding(this, elementChanges);
        }
    }

    @Deprecated
    public void setValueBindingAdHoc(String binding) {
        this.setValueBinding((ModelBinding)this.createAdHocModelBinding(binding));
    }

    @Override
    public OutputLabel createNewSameComponent() {
        return new OutputLabel(this.getForm());
    }

    @Override
    public void doCopy(Table table, Map<String, String> iteratorReplacements, OutputLabel clone) {
        TableComponent.super.doCopy(table, iteratorReplacements, clone);
        clone.setIconBinding((ModelBinding<String>)table.getRowBinding(this.getIconBinding(), (Component)clone, iteratorReplacements));
        clone.setValueBinding(table.getRowBinding(this.getValueBinding(), (Component)clone, iteratorReplacements));
        clone.setFormatter(table.getRowBinding(this.getFormatter(), iteratorReplacements));
        clone.setOnClick(table.getRowBinding(this.getOnClick(), (Component)clone, iteratorReplacements));
    }

    public void setBody(String body) {
        this.setValueBinding((ModelBinding)this.createAdHocModelBinding(body));
        this.value = "body";
    }

    public String getBodyAttributeName() {
        return ATTR_VALUE;
    }

    public ModelBinding getIconBinding() {
        return this.iconBinding;
    }

    public Optional<ActionBinding> getEventHandler(InMessageEventData eventData) {
        if (eventData.getEventType().equals(ATTR_ON_CLICK)) {
            return Optional.ofNullable(this.onClick);
        }
        return super.getEventHandler(eventData);
    }

    protected List<ActionBinding> getAvailablityAffectingActions() {
        return Collections.singletonList(this.onClick);
    }

    public IActionCallbackContext setOnClick(IActionCallback callback) {
        return CallbackActionBinding.createAndSet((IActionCallback)callback, this::setOnClick);
    }

    public void setOnClick(ActionBinding onClick) {
        this.onClick = onClick;
    }

    public boolean isModificationEvent(String eventType) {
        if (ATTR_ON_CLICK.equals(eventType)) {
            return false;
        }
        return super.isModificationEvent(eventType);
    }

    public void setIconBinding(ModelBinding<String> iconBinding) {
        this.iconBinding = iconBinding;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public IconAlignment getIconAlignment() {
        return this.iconAlignment;
    }

    public void setIconAlignment(IconAlignment iconAlignment) {
        this.iconAlignment = iconAlignment;
    }

    public String getValue() {
        return this.value;
    }

    public ModelBinding getValueBinding() {
        return this.valueBinding;
    }

    public void setValueBinding(ModelBinding valueBinding) {
        this.valueBinding = valueBinding;
    }

    public String getFormatter() {
        return this.formatter;
    }

    public void setFormatter(String formatter) {
        this.formatter = formatter;
    }

    public ActionBinding getOnClick() {
        return this.onClick;
    }
}

