/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.validation.impl;

import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import pl.fhframework.core.i18n.MessageService;
import pl.fhframework.model.forms.BaseInputField;
import pl.fhframework.model.forms.validation.impl.IsRequired;
import pl.fhframework.validation.ConstraintViolation;

@Component
public class CheckBoxIsRequired
extends IsRequired {
    @Autowired
    private MessageService messageService;

    @Override
    public List<ConstraintViolation<BaseInputField>> validate(BaseInputField value) {
        ArrayList<ConstraintViolation<BaseInputField>> violations = new ArrayList<ConstraintViolation<BaseInputField>>();
        boolean canBeValidated = super.canProcessValidation(value);
        if (canBeValidated && Boolean.FALSE.equals(value.getModelBinding().getBindingResult().getValue())) {
            this.addConstraintViolation(violations, value, this.messageService.getAllBundles().getMessage("fh.core.validation.field.is_required"));
        }
        return violations;
    }
}

