/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.function.Consumer;
import pl.fhframework.annotations.TemplateControl;
import pl.fhframework.model.forms.AccessibilityEnum;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.FormElement;
import pl.fhframework.model.forms.GroupingComponent;
import pl.fhframework.model.forms.IGroupingComponent;
import pl.fhframework.model.forms.attribute.HorizontalAlign;
import pl.fhframework.model.forms.attribute.VerticalAlign;

@TemplateControl(tagName="fh-table-cell")
public class TableCell
extends GroupingComponent<FormElement> {
    private int rowspan;
    private HorizontalAlign horizontalAlign;
    private VerticalAlign verticalAlign;
    private AccessibilityEnum visibility;
    @JsonIgnore
    public int rowIndex;

    public TableCell(Form form) {
        super(form);
    }

    @JsonProperty(value="tableCells")
    public List<FormElement> getSubcomponents() {
        return super.getSubcomponents();
    }

    public void doActionForEverySubcomponent(Consumer<FormElement> action) {
        for (FormElement cell : this.getSubcomponents()) {
            action.accept(cell);
            if (!(cell instanceof IGroupingComponent)) continue;
            ((IGroupingComponent)cell).doActionForEverySubcomponent(action);
        }
    }

    public int getRowspan() {
        return this.rowspan;
    }

    public void setRowspan(int rowspan) {
        this.rowspan = rowspan;
    }

    public HorizontalAlign getHorizontalAlign() {
        return this.horizontalAlign;
    }

    public void setHorizontalAlign(HorizontalAlign horizontalAlign) {
        this.horizontalAlign = horizontalAlign;
    }

    public VerticalAlign getVerticalAlign() {
        return this.verticalAlign;
    }

    public void setVerticalAlign(VerticalAlign verticalAlign) {
        this.verticalAlign = verticalAlign;
    }

    public AccessibilityEnum getVisibility() {
        return this.visibility;
    }

    public void setVisibility(AccessibilityEnum visibility) {
        this.visibility = visibility;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public void setRowIndex(int rowIndex) {
        this.rowIndex = rowIndex;
    }
}

