/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.composites.searchlist;

import java.util.List;
import java.util.stream.Collectors;
import pl.fhframework.annotations.Action;
import pl.fhframework.annotations.composite.Composite;
import pl.fhframework.annotations.composite.FireEvent;
import pl.fhframework.events.ViewEvent;
import pl.fhframework.model.forms.CompositeForm;
import pl.fhframework.model.forms.composites.searchlist.SearchListModel;
import pl.fhframework.model.forms.model.OptionsListElementModel;

@Composite(template="SearchList", model=SearchListModel.class, registeredEvents={"onSearchCompleted"})
public class SearchList
extends CompositeForm<SearchListModel> {
    @Action
    @FireEvent(name={"onSearch"})
    public void onSearch(ViewEvent<SearchListModel> viewEvent) {
        SearchListModel model = (SearchListModel)viewEvent.getSourceForm().getModel();
        List<OptionsListElementModel> originalSource = model.getOriginalListElements();
        String input = model.getInputValue();
        model.setListElements(originalSource.stream().filter(e -> e.getValue().toLowerCase().contains(this.nullAsEmpty(input).toLowerCase())).collect(Collectors.toList()));
    }

    private String nullAsEmpty(String s) {
        if (s == null) {
            return "";
        }
        return s;
    }
}

