/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.attributes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.util.ClassUtils;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.attributes.Attribute;
import pl.fhframework.model.forms.attributes.AttributeHolderSerializer;
import pl.fhframework.model.forms.attributes.BoundableAttribute;

public class AttributeHolder {
    @JsonSerialize(using=AttributeHolderSerializer.class)
    private Map<Class<? extends Attribute>, Attribute> attributes = new LinkedHashMap<Class<? extends Attribute>, Attribute>();
    @JsonIgnore
    private Map<Class<? extends BoundableAttribute>, BoundableAttribute> boundableAttributes = new LinkedHashMap<Class<? extends BoundableAttribute>, BoundableAttribute>();

    public void addAttribute(Attribute attribute) {
        this.attributes.put(attribute.getClass(), attribute);
        if (ClassUtils.isAssignableValue(BoundableAttribute.class, (Object)attribute)) {
            BoundableAttribute boundableAttribute = (BoundableAttribute)((Object)attribute);
            this.boundableAttributes.put(boundableAttribute.getClass(), boundableAttribute);
        }
    }

    public ElementChanges updateView(Component component, ElementChanges elementChanges, Class<? extends BoundableAttribute> pinnedAttributeClass) {
        BoundableAttribute attribute = this.boundableAttributes.get(pinnedAttributeClass);
        if (attribute != null) {
            return attribute.updateView(component, elementChanges);
        }
        return elementChanges;
    }

    public ElementChanges updateView(Component component, ElementChanges elementChanges) {
        Collection<BoundableAttribute> attributes = this.boundableAttributes.values();
        for (BoundableAttribute attribute : attributes) {
            elementChanges = attribute.updateView(component, elementChanges);
        }
        return elementChanges;
    }

    public void updateModel(Component component, ValueChange valueChange, Class<? extends BoundableAttribute> pinnedAttributeClass) {
        BoundableAttribute attribute = this.boundableAttributes.get(pinnedAttributeClass);
        if (attribute != null) {
            attribute.updateModel(component, valueChange);
        }
    }

    public void updateModel(Component component, ValueChange valueChange) {
        Collection<BoundableAttribute> attributes = this.boundableAttributes.values();
        for (BoundableAttribute attribute : attributes) {
            if (attribute == null) continue;
            attribute.updateModel(component, valueChange);
        }
    }

    public <T> T get(Class<T> attributeClass) {
        return (T)this.attributes.get(attributeClass);
    }
}

