/*
 * Decompiled with CFR 0.152.
 */
package pl.fhframework.model.forms.attributes;

import com.fasterxml.jackson.annotation.JsonIgnore;
import pl.fhframework.BindingResult;
import pl.fhframework.annotations.XMLProperty;
import pl.fhframework.binding.ModelBinding;
import pl.fhframework.model.dto.ElementChanges;
import pl.fhframework.model.dto.ValueChange;
import pl.fhframework.model.forms.Component;
import pl.fhframework.model.forms.Form;
import pl.fhframework.model.forms.attributes.Attribute;
import pl.fhframework.model.forms.attributes.BoundableAttribute;

public abstract class BoundableBoleanAttribute
extends Attribute<Boolean>
implements BoundableAttribute {
    private Boolean value;
    @JsonIgnore
    @XMLProperty(value="value")
    private ModelBinding modelBinding;

    public BoundableBoleanAttribute(Form form, Component component, ModelBinding modelBinding) {
        super(form, component);
        if (modelBinding != null) {
            BindingResult bindingResult = modelBinding.getBindingResult();
            String attributeValueString = this.convertBindingToString(bindingResult);
            this.value = Boolean.TRUE.toString().equalsIgnoreCase(attributeValueString);
        } else {
            this.value = this.getDefaultValue();
        }
        this.modelBinding = modelBinding;
    }

    @Override
    @JsonIgnore
    public Boolean getValue() {
        return this.value;
    }

    @Override
    public void setValue(Boolean value) {
        this.value = value;
    }

    @Override
    @JsonIgnore
    public abstract String getXmlValue();

    @Override
    public Boolean getDefaultValue() {
        return Boolean.FALSE;
    }

    @Override
    public ElementChanges updateView(Component component, ElementChanges elementChanges) {
        boolean newValue;
        BindingResult bindingResult;
        if (this.modelBinding != null && (bindingResult = this.modelBinding.getBindingResult()) != null && (newValue = Boolean.valueOf(component.convertBindingValueToString(bindingResult)).booleanValue()) != this.value) {
            this.value = newValue;
            elementChanges.addChange(this.getXmlValue(), (Object)this.value);
        }
        return elementChanges;
    }

    @Override
    public void updateModel(Component component, ValueChange valueChange) {
        Boolean pinnedAttributeNewValue = valueChange.getBooleanAttribute(this.getXmlValue());
        if (pinnedAttributeNewValue != null && pinnedAttributeNewValue.booleanValue() != this.value.booleanValue()) {
            this.value = pinnedAttributeNewValue;
            this.updateBindingForValue(pinnedAttributeNewValue, this.modelBinding, this.value);
        }
    }

    @Override
    public ModelBinding getModelBinding() {
        return this.modelBinding;
    }

    @Override
    public void setModelBinding(ModelBinding modelBinding) {
        this.modelBinding = modelBinding;
    }
}

