/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.smartparam.engine.types.date.SimpleDateFormatPool;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public abstract class HprDate {
    public static final String YMD = "yyyy-MM-dd";
    public static final String YMDHMS = "yyyy-MM-dd HH:mm:ss";
    public static final String YMDHMSMS = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DMY = "dd-MM-yyyy";

    public static String format(Date d) {
        return HprDate.format(d, YMD);
    }

    public static String formatTimestamp(Date d) {
        return HprDate.format(d, YMDHMSMS);
    }

    public static String formatTimestamp(long timestamp) {
        return HprDate.formatTimestamp(new Date(timestamp));
    }

    public static String format(Date d, String pattern) {
        return d != null ? HprDate.getSimpleDateFormat(pattern).format(d) : null;
    }

    public static SimpleDateFormat getSimpleDateFormat(String pattern) {
        return SimpleDateFormatPool.get(pattern);
    }

    public static Date parse(String text) {
        return HprDate.guess(text);
    }

    public static Date guess(String text) {
        String dateStr = text.trim();
        if (dateStr.length() == 10) {
            char c2;
            char c1 = dateStr.charAt(2);
            if (HprDate.bothEqualTo(c1, c2 = dateStr.charAt(5), '-')) {
                return HprDate.parse(dateStr, DMY);
            }
            if (HprDate.bothEqualTo(c1, c2, '.')) {
                return HprDate.parse(dateStr, "dd.MM.yyyy");
            }
            if (HprDate.bothEqualTo(c1, c2, '/')) {
                return HprDate.parse(dateStr, "dd/MM/yyyy");
            }
            c1 = dateStr.charAt(4);
            if (HprDate.bothEqualTo(c1, c2 = dateStr.charAt(7), '-')) {
                return HprDate.parse(dateStr, YMD);
            }
            if (HprDate.bothEqualTo(c1, c2, '.')) {
                return HprDate.parse(dateStr, "yyyy.MM.dd");
            }
            if (HprDate.bothEqualTo(c1, c2, '/')) {
                return HprDate.parse(dateStr, "yyyy/MM/dd");
            }
        }
        throw new IllegalArgumentException("Unknown date format: [" + dateStr + "]");
    }

    public static int parseTime(String text) {
        int h = 0;
        int m = 0;
        int s = 0;
        int ms = 0;
        int state = 1;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (c == ':' || c == '.' || c == ',' || c == ' ') {
                ++state;
                continue;
            }
            int d = c - 48;
            if (state == 1) {
                h = h * 10 + d;
                continue;
            }
            if (state == 2) {
                m = m * 10 + d;
                continue;
            }
            if (state == 3) {
                s = s * 10 + d;
                continue;
            }
            if (state != 4) continue;
            ms = ms * 10 + d;
        }
        if (state > 4 || h > 23 || m > 59 || s > 59 || ms > 999) {
            throw new HyperonRuntimeException("Illegal time format: " + text);
        }
        return (h * 3600 + m * 60 + s) * 1000 + ms;
    }

    private static boolean bothEqualTo(char c1, char c2, char expected) {
        return c1 == expected && c2 == expected;
    }

    public static Date parse(String dateStr, String pattern) {
        try {
            return SimpleDateFormatPool.get(pattern).parse(dateStr);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Cannot parse date string [" + dateStr + "]", e);
        }
    }
}

