/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sql;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.sql.HyperonDialect;
import pl.decerto.hyperon.runtime.sql.SqlProcessor;
import pl.decerto.hyperon.runtime.sql.dialect.OracleHyperonDialect;

public class DialectTemplate {
    private String schema;
    private HyperonDialect dialect;
    private SqlProcessor processor;

    DialectTemplate() {
    }

    DialectTemplate(HyperonDialect dialect) {
        this.setDialect(dialect);
    }

    final void setDialect(HyperonDialect dialect) {
        this.dialect = dialect;
        this.processor = new SqlProcessor(dialect, this.schema);
    }

    final void setSchema(String schema) {
        this.schema = schema;
        this.processor = new SqlProcessor(this.dialect, schema);
    }

    public HyperonDialect getDialect() {
        return this.dialect;
    }

    public String getSchema() {
        return this.schema;
    }

    public String table(String table) {
        return this.dialect.table(table);
    }

    public String column(String column) {
        return this.dialect.column(column);
    }

    public String selectFromSequence(String sequence) {
        return this.dialect.selectFromSequence(sequence, this.schema);
    }

    public String getValidationQuery() {
        return this.dialect.validationQuery();
    }

    public String getJdbcDriverClassName() {
        return this.dialect.jdbcDriverClassName();
    }

    public String getHibernateDialect() {
        return this.dialect.hibernateDialect();
    }

    public String parse(String sql) {
        return this.processor.parse(sql);
    }

    public int getInt(ResultSet rs, String column) throws SQLException {
        return rs.getInt(this.column(column));
    }

    public String getString(ResultSet rs, String column) throws SQLException {
        return rs.getString(this.column(column));
    }

    public String getStringIntern(ResultSet rs, String column) throws SQLException {
        String s = this.getString(rs, column);
        return s != null ? s.intern() : null;
    }

    public boolean getBoolean(ResultSet rs, String column) throws SQLException {
        return rs.getBoolean(this.column(column));
    }

    public Date getDate(ResultSet rs, String column) throws SQLException {
        return rs.getDate(this.column(column));
    }

    public Date getTimestamp(ResultSet rs, String column) throws SQLException {
        Timestamp t = rs.getTimestamp(column);
        return t != null ? new Date(t.getTime()) : null;
    }

    public <T extends Enum<T>> T getEnum(ResultSet rs, String column, Class<T> enumClass) throws SQLException {
        String code = this.getString(rs, column);
        return code != null ? (T)this.codeToEnum(code, enumClass) : null;
    }

    public String getOracleHint(String content) {
        if (this.dialect instanceof OracleHyperonDialect) {
            return "/*+ " + content + " */";
        }
        return "";
    }

    private <T extends Enum<T>> T codeToEnum(String code, Class<T> enumClass) {
        try {
            return Enum.valueOf(enumClass, code);
        }
        catch (IllegalArgumentException e) {
            throw new HyperonRuntimeException("Enum  " + enumClass + " does not support value: " + code, e);
        }
    }
}

