/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sorter;

import java.util.Locale;
import pl.decerto.hyperon.runtime.sorter.SortOrder;

public class SortColumn {
    private final String name;
    private final int outNo;
    private SortOrder order = SortOrder.ASC;
    private boolean text;
    private Locale locale;
    private boolean ignoreCase = true;

    public SortColumn(String name, int outNo, Locale locale, boolean ignoreCase) {
        this.name = name;
        this.outNo = outNo;
        this.locale = locale;
        this.ignoreCase = ignoreCase;
    }

    public SortColumn(String name, int outNo) {
        this(name, outNo, null, true);
    }

    public int getOutNo() {
        return this.outNo;
    }

    public SortOrder getOrder() {
        return this.order;
    }

    public void setOrder(SortOrder order) {
        this.order = order;
    }

    public boolean isText() {
        return this.text;
    }

    public void setText(boolean text) {
        this.text = text;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public void setLocale(String lang) {
        this.locale = lang != null ? new Locale(lang) : null;
    }

    public String getName() {
        return this.name;
    }

    public boolean isIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append('{').append(this.name);
        sb.append(' ').append((Object)this.order);
        if (this.text) {
            sb.append(" text");
        }
        if (this.locale != null) {
            sb.append(' ').append(this.locale.getDisplayName());
        }
        if (!this.isIgnoreCase()) {
            sb.append(" sensitive");
        }
        sb.append('}');
        return sb.toString();
    }
}

