/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.security;

import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.security.DefaultKey;

public class KeyProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeyProvider.class);

    public PrivateKey getPrivateKey(String path) {
        LOGGER.trace("trying to get private key from resource path:{}", (Object)path);
        PrivateKey privateKey = this.getPrivateKeyFromResources(path);
        if (privateKey == null) {
            LOGGER.trace("trying to get private key from path:{}", (Object)path);
            privateKey = this.getPrivateKeyFromPath(path);
        }
        if (privateKey != null) {
            return privateKey;
        }
        throw new HyperonRuntimeException("could not find private key in given path:" + path);
    }

    public PrivateKey getPrivateKeyFromResources(String resourcePath) {
        LOGGER.trace("getting privateKey from resource path:{}", (Object)resourcePath);
        URL resource = this.getClass().getClassLoader().getResource(resourcePath);
        if (resource != null) {
            return this.getPrivateKey(resource);
        }
        LOGGER.error("Could not get private key from resource path:{}", (Object)resourcePath);
        return null;
    }

    public PrivateKey getPrivateKeyFromPath(String privateKeyPath) {
        LOGGER.trace("getting privateKey from path:{}", (Object)privateKeyPath);
        try {
            return this.createPrivateKey(Files.readAllBytes(Paths.get(privateKeyPath, new String[0])));
        }
        catch (IOException e) {
            LOGGER.error("Could not get private key from path:{}, errorMessage:{}", (Object)privateKeyPath, (Object)e.getMessage());
            return null;
        }
    }

    public PrivateKey getPrivateKey(URL url) {
        return this.createPrivateKey(this.toByteArray(url));
    }

    public PublicKey getPublicKey(URL url) {
        return this.createPublicKey(this.toByteArray(url));
    }

    private PrivateKey createPrivateKey(byte[] privateKeyBytes) {
        try {
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(privateKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
            return keyFactory.generatePrivate(privKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new HyperonRuntimeException("could not create private key", e);
        }
    }

    public PublicKey getPublicKey() {
        return this.getPublicKey(DefaultKey.PUBLIC.getResourcePath());
    }

    public PublicKey getPublicKey(String path) {
        LOGGER.trace("trying to get public key from resource path:{}", (Object)path);
        PublicKey publicKey = this.getPublicKeyFromResources(path);
        if (publicKey == null) {
            LOGGER.trace("trying to get public key from path:{}", (Object)path);
            publicKey = this.getPublicKeyFromPath(path);
        }
        if (publicKey != null) {
            return publicKey;
        }
        throw new HyperonRuntimeException("could not find public key in given path:" + path);
    }

    public PublicKey getPublicKeyFromPath() {
        return this.getPublicKey(DefaultKey.PUBLIC.getFullPath());
    }

    public PublicKey getPublicKeyFromPath(String publicKeyPath) {
        LOGGER.trace("getting publicKey from {}", (Object)publicKeyPath);
        try {
            return this.createPublicKey(Files.readAllBytes(Paths.get(publicKeyPath, new String[0])));
        }
        catch (IOException e) {
            LOGGER.error("Could not get public key from path:{}, errorMessage:{}", (Object)publicKeyPath, (Object)e.getMessage());
            return null;
        }
    }

    public PublicKey getPublicKeyFromResources() {
        return this.getPublicKeyFromResources(DefaultKey.PUBLIC.getResourcePath());
    }

    public PublicKey getPublicKeyFromResources(String resourcePath) {
        LOGGER.trace("getting publicKey from {}", (Object)resourcePath);
        URL resource = this.getClass().getClassLoader().getResource(resourcePath);
        if (resource != null) {
            byte[] publicKeyBytes = this.toByteArray(resource);
            return this.createPublicKey(publicKeyBytes);
        }
        LOGGER.error("Could not get public key from resource path:{}", (Object)resourcePath);
        return null;
    }

    private PublicKey createPublicKey(byte[] publicKeyBytes) {
        try {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(publicKeyBytes);
            KeyFactory keyFactory = KeyFactory.getInstance("RSA", "SunRsaSign");
            return keyFactory.generatePublic(pubKeySpec);
        }
        catch (NoSuchAlgorithmException | NoSuchProviderException | InvalidKeySpecException e) {
            throw new HyperonRuntimeException("could not create public key", e);
        }
    }

    /*
     * Exception decompiling
     */
    private byte[] toByteArray(URL resource) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

