/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.provider.external;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import pl.decerto.hyperon.runtime.provider.external.ExtSql;

public class ExtSqlParser {
    private static final char DEFAULT_ARG_SYMBOL = ':';
    private static final Map<String, ExtSql> cache = new ConcurrentHashMap<String, ExtSql>();

    public static ExtSql parse(String sql) {
        ExtSql ext = cache.get(sql);
        if (ext == null) {
            ext = ExtSqlParser.parseInternal(sql);
            cache.put(sql, ext);
        }
        return ext;
    }

    private static ExtSql parseInternal(String sql) {
        String text = sql.trim();
        char argSymbol = ':';
        if (text.startsWith("arg")) {
            int ix = ExtSqlParser.findFirstNonWhite(text, 3);
            argSymbol = text.charAt(ix);
            text = text.substring(ix + 1).trim();
        }
        return ExtSqlParser.scan(text, argSymbol);
    }

    private static ExtSql scan(String str, char c) {
        ExtSql ext = new ExtSql(str, c);
        StringBuilder sb = new StringBuilder(str.length());
        int i = 0;
        while (i < str.length()) {
            int last = i;
            int begin = str.indexOf(c, i);
            if (begin < 0) {
                sb.append(str.substring(last));
                break;
            }
            sb.append(str.substring(last, begin));
            int end = ExtSqlParser.findFirstNonIdentifier(str, begin + 1);
            String token = str.substring(begin + 1, end);
            ext.addArgument(token);
            sb.append("?");
            i = end;
        }
        ext.setSql(sb.toString());
        return ext;
    }

    private static int findFirstNonWhite(String str, int ix) {
        int i = ix;
        while (Character.isWhitespace(str.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static int findFirstNonIdentifier(String str, int ix) {
        for (int i = ix; i < str.length(); ++i) {
            char ch = str.charAt(i);
            if (Character.isLetterOrDigit(ch) || ch == '_') continue;
            return i;
        }
        return str.length();
    }

    protected static Map<String, ExtSql> cache() {
        return cache;
    }
}

