/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.provider.external;

import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.matchers.BetweenMatcherTokenSeparator;
import org.smartparam.engine.matchers.RangeToken;
import pl.decerto.hyperon.runtime.dao.util.RowCallbackHandler;
import pl.decerto.hyperon.runtime.helper.HyperonLevelConstants;
import pl.decerto.hyperon.runtime.helper.MpHelper;
import pl.decerto.hyperon.runtime.helper.TypeConverter;
import pl.decerto.hyperon.runtime.model.MpLevel;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.model.MpParameterEntry;

class ExtRowCallbackHandler
implements RowCallbackHandler {
    private final MpParameter parameter;
    private final TypeConverter typeConverter;
    private final MpHelper helper;

    ExtRowCallbackHandler(MpParameter parameter) {
        this.parameter = parameter;
        this.typeConverter = new TypeConverter();
        this.helper = new MpHelper();
    }

    @Override
    public void processRow(ResultSet rs) throws SQLException {
        int levelCnt = this.parameter.getLevelCount();
        String[] row = new String[levelCnt];
        for (int i = 0; i < levelCnt; ++i) {
            Object obj = rs.getObject(i + 1);
            if (obj == null) continue;
            MpLevel level = this.parameter.getLevel(i);
            String type = level.getType();
            row[i] = HyperonLevelConstants.ASTERISK.getValue().equals(obj.toString()) ? HyperonLevelConstants.ASTERISK.getValue() : (this.isBetweenMatcher(level.getMatcher()) ? this.getBetweenMatcherConvertedValue(obj, type) : this.typeConverter.toHolder(obj, type).getString());
        }
        MpParameterEntry entry = this.helper.createEntry(this.parameter, row);
        this.parameter.addEntry(entry);
    }

    private boolean isBetweenMatcher(String matcher) {
        return StringUtils.isNotEmpty((CharSequence)matcher) && (StringUtils.equals((CharSequence)matcher, (CharSequence)"between/ie") || StringUtils.equals((CharSequence)matcher, (CharSequence)"between/ii"));
    }

    private String getBetweenMatcherConvertedValue(Object value, String type) {
        String parsedRangeValues = this.typeConverter.getString(value);
        BetweenMatcherTokenSeparator separator = new BetweenMatcherTokenSeparator();
        RangeToken rangeToken = separator.separate(parsedRangeValues);
        String convertedLowerRange = this.typeConverter.toHolder((Object)rangeToken.getLower(), type).getString();
        String convertedUpperRange = this.typeConverter.toHolder((Object)rangeToken.getUpper(), type).getString();
        return convertedLowerRange + rangeToken.getSeparator() + convertedUpperRange;
    }
}

