/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model.proxy;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.model.DomainTokenResolver;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;
import pl.decerto.hyperon.runtime.model.MpRegionCached;
import pl.decerto.hyperon.runtime.model.proxy.HyperonDomainAttributeProxy;

public class HyperonDomainObjectProxy
implements HyperonDomainObject {
    private final HyperonDomainObject obj;
    private final HyperonEngine engine;
    private final String profile;
    private final String callPath;

    @Override
    public HyperonDomainObject getDomain(String objectPath) {
        HyperonDomainObject childObj = this.obj.getDomain(objectPath);
        if (childObj == null) {
            return childObj;
        }
        String childPath = HyperonDomainObjectProxy.toPath(this.callPath, objectPath);
        return new HyperonDomainObjectProxy(childObj, this.engine, this.profile, childPath);
    }

    @Override
    public String getCode() {
        return this.obj.getCode();
    }

    @Override
    public String getName() {
        return this.obj.getName();
    }

    @Override
    public String getTypeCode() {
        return this.obj.getTypeCode();
    }

    @Override
    public String getTypeName() {
        return this.obj.getTypeName();
    }

    @Override
    public String getPath() {
        return this.obj.getPath();
    }

    @Override
    public HyperonDomainAttribute getAttribute(String code) {
        return this.getProxy(this.obj.getAttribute(code));
    }

    @Override
    public boolean isAttrSet(String code) {
        return this.obj.isAttrSet(code);
    }

    @Override
    public List<HyperonDomainAttribute> getAttributes() {
        return this.getProxyAttributes(this.obj.getAttributes());
    }

    @Override
    public HyperonDomainAttribute getDynamicAttribute(String code) {
        return this.getProxy(this.obj.getDynamicAttribute(code));
    }

    @Override
    public List<HyperonDomainAttribute> getDynamicAttributes() {
        return this.getProxyAttributes(this.obj.getDynamicAttributes());
    }

    private List<HyperonDomainAttribute> getProxyAttributes(List<HyperonDomainAttribute> attrList) {
        ArrayList<HyperonDomainAttribute> proxyList = new ArrayList<HyperonDomainAttribute>(attrList.size());
        for (HyperonDomainAttribute attr : attrList) {
            proxyList.add(new HyperonDomainAttributeProxy(attr, this));
        }
        return proxyList;
    }

    @Override
    public HyperonDomainObject getChild(String propCode, String code) {
        HyperonDomainObject child = this.obj.getChild(propCode, code);
        if (child == null) {
            return null;
        }
        String childPath = HyperonDomainObjectProxy.toPath(this.callPath, HyperonDomainObjectProxy.toElement(propCode, code));
        return new HyperonDomainObjectProxy(child, this.engine, this.profile, childPath);
    }

    @Override
    public List<HyperonDomainObject> getChildren(String propCode) {
        List<HyperonDomainObject> children = this.obj.getChildren(propCode);
        if (children.isEmpty()) {
            return children;
        }
        ArrayList<HyperonDomainObject> proxyChildren = new ArrayList<HyperonDomainObject>(children.size());
        for (HyperonDomainObject child : children) {
            String childPath = HyperonDomainObjectProxy.toPath(this.callPath, HyperonDomainObjectProxy.toElement(propCode, child.getCode()));
            proxyChildren.add(new HyperonDomainObjectProxy(child, this.engine, this.profile, childPath));
        }
        return proxyChildren;
    }

    @Override
    public HyperonDomainObject getParent() {
        String parentPath = this.getParentPath();
        return this.getProxy(this.engine.getDomain(this.profile, parentPath), parentPath);
    }

    private HyperonDomainObject getProxy(HyperonDomainObject obj, String callPath) {
        return obj != null ? new HyperonDomainObjectProxy(obj, this.engine, this.profile, callPath) : null;
    }

    private HyperonDomainAttribute getProxy(HyperonDomainAttribute attr) {
        return attr != null ? new HyperonDomainAttributeProxy(attr, this) : null;
    }

    @Override
    public HyperonDomainAttribute getAttribute(String path, String attributeCode) {
        HyperonDomainAttribute attr = this.obj.getAttribute(path, attributeCode);
        return attr != null ? new HyperonDomainAttributeProxy(attr, this) : null;
    }

    @Override
    public ParamValue getAttributeValue(String path, String attributeCode, ParamContext ctx, Object ... args) {
        return this.obj.getAttributeValue(path, attributeCode, ctx, args);
    }

    @Override
    public boolean isRoot() {
        return this.obj.isRoot();
    }

    @Override
    public boolean isAttrDefined(String code) {
        return this.obj.isAttrDefined(code);
    }

    @Override
    public HyperonDomainAttribute getAttr(String code) {
        return this.getAttribute(code);
    }

    @Override
    public String getAttrString(String attrCode, HyperonContext ctx) {
        return this.obj.getAttrString(attrCode, ctx);
    }

    @Override
    public BigDecimal getAttrDecimal(String attrCode, HyperonContext ctx) {
        return this.obj.getAttrDecimal(attrCode, ctx);
    }

    @Override
    public double getAttrNumber(String attrCode, HyperonContext ctx) {
        return this.obj.getAttrNumber(attrCode, ctx);
    }

    @Override
    public Integer getAttrInteger(String attrCode, HyperonContext ctx) {
        return this.obj.getAttrInteger(attrCode, ctx);
    }

    @Override
    public Date getAttrDate(String attrCode, HyperonContext ctx) {
        return this.obj.getAttrDate(attrCode, ctx);
    }

    @Override
    public boolean getAttrBoolean(String attrCode, HyperonContext ctx) {
        return this.obj.getAttrBoolean(attrCode, ctx);
    }

    @Override
    public Integer getId() {
        return this.obj.getId();
    }

    @Override
    public Integer getParentId() {
        return this.obj.getParentId();
    }

    @Override
    public String getCallPath() {
        return this.callPath;
    }

    @Override
    public HyperonDomainObjectType getTypeCollection() {
        return this.obj.getTypeCollection();
    }

    @Override
    public MpRegionCached getRegion() {
        return this.obj.getRegion();
    }

    public HyperonDomainObject unwrap() {
        return this.obj;
    }

    public static String toPath(String domainPath) {
        if (StringUtils.isBlank((CharSequence)domainPath)) {
            return "/";
        }
        String path = domainPath.trim();
        if (path.equals("/")) {
            return path;
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return path;
    }

    public static String toPath(String path1, String path2) {
        String p1 = HyperonDomainObjectProxy.toPath(path1);
        String p2 = HyperonDomainObjectProxy.toPath(path2);
        if (p1.endsWith("/")) {
            p1 = p1.substring(0, p1.length() - 1);
        }
        return HyperonDomainObjectProxy.toPath(p1 + p2);
    }

    public static String toElement(String collectionCode, String elementCode) {
        return DomainTokenResolver.resolveFullToken(collectionCode, elementCode);
    }

    public static String rejectLastToken(String path) {
        int lastIx = path.lastIndexOf(47);
        if (lastIx >= 0) {
            return HyperonDomainObjectProxy.toPath(path.substring(0, lastIx));
        }
        return "/";
    }

    public String getParentPath() {
        return HyperonDomainObjectProxy.rejectLastToken(this.callPath);
    }

    public String toString() {
        return "HyperonDomainObjectProxy[id=" + this.getId() + ", parent=" + this.getParentId() + ", callPath=" + this.callPath + ", path=" + this.getPath() + ", profile=" + this.profile + ']';
    }

    public HyperonDomainObjectProxy(HyperonDomainObject obj, HyperonEngine engine, String profile, String callPath) {
        this.obj = obj;
        this.engine = engine;
        this.profile = profile;
        this.callPath = callPath;
    }
}

