/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.Date;

public class MpScheduleEntry {
    private String region;
    private String version;
    private Date dateFrom;
    private Date dateTo;

    public MpScheduleEntry(String region, String version, Date dateFrom) {
        this.region = region;
        this.version = version;
        this.dateFrom = dateFrom;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MpScheduleEntry)) {
            return false;
        }
        MpScheduleEntry e = (MpScheduleEntry)o;
        return this.eq(this.dateFrom, e.dateFrom) && this.eq(this.dateTo, e.dateTo) && this.eq(this.region, e.region) && this.eq(this.version, e.version);
    }

    private boolean eq(Date d1, Date d2) {
        if (d1 == null || d2 == null) {
            return d1 == d2;
        }
        return d1.getTime() == d2.getTime();
    }

    private boolean eq(Object o1, Object o2) {
        if (o1 == null || o2 == null) {
            return o1 == o2;
        }
        return o1.equals(o2);
    }

    public int hashCode() {
        int result = this.region.hashCode();
        result = 31 * result + this.version.hashCode();
        result = 31 * result + this.hash(this.dateFrom);
        result = 31 * result + this.hash(this.dateTo);
        return result;
    }

    private int hash(Date d) {
        return d == null ? 0 : (int)d.getTime() ^ (int)(d.getTime() >> 32);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ScheduleEntry[");
        sb.append(this.region).append('/').append(this.version);
        sb.append(", date range: ").append(this.dateFrom).append(" : ").append(this.dateTo);
        sb.append(']');
        return sb.toString();
    }

    public String getRegion() {
        return this.region;
    }

    public String getVersion() {
        return this.version;
    }

    public Date getDateFrom() {
        return this.dateFrom;
    }

    public Date getDateTo() {
        return this.dateTo;
    }

    public void setDateTo(Date dateTo) {
        this.dateTo = dateTo;
    }
}

