/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.license;

import java.text.SimpleDateFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.types.date.SimpleDateFormatPool;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDetailsDto;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDto;

public class LicensePrintUtils {
    private static final Logger log = LoggerFactory.getLogger(LicensePrintUtils.class);
    private static final String LICENSE_DECORATOR = "===================== LICENSE =====================";

    private LicensePrintUtils() {
        throw new UnsupportedOperationException();
    }

    public static void printNoValidLicenseInformation() {
        LicensePrintUtils.printLicenseHeader();
        log.info("no valid license found!");
        log.info("visit hyperon.io to obtain license");
        LicensePrintUtils.printLicenseFooter();
    }

    public static void printLicenseNotVerifiedInformation(HyperonLicenseDto license) {
        LicensePrintUtils.printLicenseHeader();
        log.info("License cannot be verified");
        log.info("If you think you shouldn't see this information, please contact Hyperon team.");
        log.info("active license info:");
        LicensePrintUtils.printLicenseInfo(license.getLicenseDetails());
        LicensePrintUtils.printLicenseFooter();
    }

    public static void printLicenseInformation(HyperonLicenseDto license) {
        LicensePrintUtils.printLicenseHeader();
        log.info("License verified");
        log.info("active license info:");
        LicensePrintUtils.printLicenseInfo(license.getLicenseDetails());
        LicensePrintUtils.printLicenseFooter();
    }

    private static void printLicenseInfo(HyperonLicenseDetailsDto licenseDetails) {
        SimpleDateFormat dateFormat = SimpleDateFormatPool.get("yyyy-MM-dd");
        if (log.isInfoEnabled()) {
            log.info("valid from:{}", (Object)dateFormat.format(licenseDetails.getValidFrom()));
            if (licenseDetails.getValidTo() != null) {
                log.info("valid to:{}", (Object)dateFormat.format(licenseDetails.getValidTo()));
            }
        }
        log.info("license number:{}", (Object)licenseDetails.getLicenseNumber());
        log.info("licensee:{}", (Object)licenseDetails.getLicensee());
        if (licenseDetails.getPermittedCpuCores() != null) {
            log.info("permitted cpu cores:{}", (Object)licenseDetails.getPermittedCpuCores());
        }
        if (licenseDetails.getSpecialConditions() != null) {
            log.info("special conditions:{}", (Object)licenseDetails.getSpecialConditions());
        }
    }

    private static void printLicenseHeader() {
        log.info(LICENSE_DECORATOR);
        log.info("");
    }

    private static void printLicenseFooter() {
        log.info("");
        log.info(LICENSE_DECORATOR);
    }
}

