/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.context.DefaultContext;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionInvoker;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.MpPropFunction;

public class PropFunctionInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(PropFunctionInvoker.class);

    @Override
    public Object invoke(Function function, Object ... args) {
        MpPropFunction f = this.cast(function);
        if (args.length == 1 && args[0] instanceof DefaultContext) {
            DefaultContext ctx = (DefaultContext)args[0];
            if (log.isTraceEnabled()) {
                log.trace("reading property: {}", (Object)f.getProperty());
            }
            return ctx.get(f.getProperty());
        }
        log.warn("illegal args: {}", (Object)Arrays.toString(args));
        throw new HyperonRuntimeException("Illegal arguments passed to PropFunction invocation");
    }

    private MpPropFunction cast(Function f) {
        if (f instanceof MpPropFunction) {
            return (MpPropFunction)f;
        }
        throw new HyperonRuntimeException("Illegal function passed to PropFunctionInvoker: " + f);
    }
}

