/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.invoker;

import groovy.lang.Binding;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionInvoker;
import pl.decerto.hyperon.runtime.constants.FunctionCode;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.function.groovy.shell.CachedGroovyShell;
import pl.decerto.hyperon.runtime.function.groovy.shell.CompiledGroovyFunction;
import pl.decerto.hyperon.runtime.model.MpGroovyFunction;
import pl.decerto.hyperon.runtime.profiler.engine.EngineProfiler;

public class GroovyFunctionInvoker
implements FunctionInvoker {
    private static final Logger log = LoggerFactory.getLogger(GroovyFunctionInvoker.class);
    private static final EngineProfiler profiler = EngineProfiler.FUNCTION;
    private final CachedGroovyShell shell = new CachedGroovyShell();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Function function, Object ... args) {
        long t = System.currentTimeMillis();
        try {
            MpGroovyFunction f = this.cast(function);
            Object object = this.call(f, args);
            return object;
        }
        finally {
            profiler.addGetMeasure(function.getName(), t, System.currentTimeMillis());
        }
    }

    private MpGroovyFunction cast(Function f) {
        if (f instanceof MpGroovyFunction) {
            return (MpGroovyFunction)f;
        }
        log.error("Unexpected function: {}", (Object)f);
        throw new HyperonRuntimeException("Illegal function passed to GroovyFunctionInvoker: " + f);
    }

    public void addGlobalObject(String code, Object obj) {
        log.debug("registering groovy global object: {} -> {}", (Object)code, obj);
        this.shell.setVariable(code, obj);
    }

    public void addGlobalObject(FunctionCode functionCode, Object obj) {
        log.debug("registering groovy global object: {} -> {}", (Object)functionCode, obj);
        this.shell.setVariable(functionCode.code(), obj);
    }

    public void invalidate(int implId) {
        log.debug("invalidating cc for impl.id: {}", (Object)implId);
        CompiledGroovyFunction f = this.shell.getCompileCache().remove(implId);
        if (f != null) {
            log.debug("found and invalidated: {}", (Object)f);
        } else {
            log.debug("impl not found in cc");
        }
    }

    public void invalidate() {
        log.debug("invalidating all compiled functions");
        this.shell.getCompileCache().clear();
    }

    public Map<Integer, CompiledGroovyFunction> getCompileCacheSnapshot() {
        return new HashMap<Integer, CompiledGroovyFunction>(this.shell.getCompileCache());
    }

    public Object getBoundVariable(String name) {
        return this.shell.getContext().getVariable(name);
    }

    private Object call(MpGroovyFunction f, Object ... passedArguments) {
        try {
            String[] declaresArgsNames = f.getArgsArray();
            Binding arguments = new Binding();
            int argumentsCount = declaresArgsNames.length;
            for (int i = 0; i < argumentsCount; ++i) {
                Object argValue = i < passedArguments.length ? passedArguments[i] : null;
                arguments.setVariable(declaresArgsNames[i], argValue);
            }
            return this.shell.evaluate(f.getImplId(), f.getVirtualName(), f.getBody(), arguments);
        }
        catch (RuntimeException e) {
            throw new HyperonRuntimeException("Groovy function invocation error", e);
        }
    }
}

