/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.helper;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Clob;
import java.sql.SQLException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.types.bool.BooleanHolder;
import org.smartparam.engine.types.date.DateHolder;
import org.smartparam.engine.types.date.DateType;
import org.smartparam.engine.types.datetime.DatetimeHolder;
import org.smartparam.engine.types.datetime.DatetimeType;
import org.smartparam.engine.types.integer.IntegerHolder;
import org.smartparam.engine.types.integer.IntegerType;
import org.smartparam.engine.types.number.NumberHolder;
import org.smartparam.engine.types.number.NumberType;
import org.smartparam.engine.types.string.StringHolder;
import org.smartparam.engine.types.string.StringType;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.helper.MathUtil;
import pl.decerto.hyperon.runtime.type.BooleanType;

public class TypeConverter {
    public static final String NUMBER_TYPE = "number";
    public static final String INTEGER_TYPE = "integer";
    public static final String STRING_TYPE = "string";
    public static final String BOOLEAN_TYPE = "boolean";
    public static final String DATE_TYPE = "date";
    public static final String DATETIME_TYPE = "datetime";
    public static final String NULL_VALUE = "null";
    private static final int NUMBER_HOLDER_CUTOFF = 12;
    private static final Map<Class<? extends ValueHolder>, String> HOLDER_TO_TYPE;
    private static final Map<Class<? extends ValueHolder>, ValueHolder> HOLDER_TO_NULL;

    public NumberHolder toNumberHolder(Object obj) {
        if (obj instanceof NumberHolder) {
            return (NumberHolder)obj;
        }
        return new NumberHolder(this.getDecimal(obj));
    }

    public double getNumber(Object obj) {
        return this.toNumberHolder(obj).doubleValue();
    }

    public double getNumber(Object obj, int scale) {
        return this.getDecimal(obj, scale).doubleValue();
    }

    public BigDecimal getDecimal(Object obj) {
        NumberHolder holder = this.convert(obj, this.getNumberType());
        return MathUtil.round(holder.getBigDecimal(), 12);
    }

    public BigDecimal getDecimal(Object obj, int scale) {
        return this.getDecimal(obj).setScale(scale, RoundingMode.HALF_UP).stripTrailingZeros();
    }

    public IntegerHolder toIntegerHolder(Object obj) {
        if (obj instanceof IntegerHolder) {
            return (IntegerHolder)obj;
        }
        if (obj instanceof NumberHolder) {
            return new IntegerHolder(((NumberHolder)obj).getLong());
        }
        if (obj instanceof Number) {
            return new IntegerHolder(((Number)obj).longValue());
        }
        if (obj == null) {
            return new IntegerHolder(null);
        }
        return new IntegerHolder(this.toNumberHolder(obj).getLong());
    }

    public Integer getInteger(Object obj) {
        return this.toIntegerHolder(obj).getInteger();
    }

    public Long getLong(Object obj) {
        return this.toIntegerHolder(obj).getLong();
    }

    public DateHolder toDateHolder(Object obj) {
        if (obj instanceof DateHolder) {
            return (DateHolder)obj;
        }
        if (obj instanceof Number) {
            long time = ((Number)obj).longValue();
            return new DateHolder(new Date(time));
        }
        return this.convert(obj, this.getDateType());
    }

    public Date getDate(Object obj) {
        return this.toDateHolder(obj).getDate();
    }

    public DatetimeHolder toDatetimeHolder(Object obj) {
        if (obj instanceof DatetimeHolder) {
            return (DatetimeHolder)obj;
        }
        if (obj instanceof DateHolder) {
            return new DatetimeHolder(((DateHolder)obj).getDate());
        }
        if (obj instanceof Number) {
            long time = ((Number)obj).longValue();
            return new DatetimeHolder(new Date(time));
        }
        return this.convert(obj, this.getDatetimeType());
    }

    public Date getDatetime(Object obj) {
        return this.toDatetimeHolder(obj).getDatetime();
    }

    public StringHolder toStringHolder(Object obj) {
        if (obj instanceof StringHolder) {
            return (StringHolder)obj;
        }
        return new StringHolder(this.toString(obj));
    }

    public String getString(Object obj) {
        return this.toString(obj);
    }

    private String toString(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof String) {
            return (String)obj;
        }
        if (obj instanceof ValueHolder) {
            return ((ValueHolder)obj).getString();
        }
        if (obj instanceof Date) {
            return this.getDateType().convert(obj).getString();
        }
        if (obj instanceof Clob) {
            return this.getClobAsString((Clob)obj);
        }
        return this.getStringType().convert(obj).getString();
    }

    private String getClobAsString(Clob clob) {
        try {
            return clob.getSubString(1L, (int)clob.length());
        }
        catch (SQLException e) {
            throw new HyperonRuntimeException("could not get string value from clob", e);
        }
    }

    public BooleanHolder toBooleanHolder(Object obj) {
        if (obj instanceof BooleanHolder) {
            return (BooleanHolder)obj;
        }
        return this.convert(obj, this.getBooleanType());
    }

    public boolean getBoolean(Object obj) {
        return this.toBooleanHolder(obj).booleanValue();
    }

    public ValueHolder toHolder(Object obj, String type) {
        if (STRING_TYPE.equals(type)) {
            return this.toStringHolder(obj);
        }
        if (NUMBER_TYPE.equals(type)) {
            return this.toNumberHolder(obj);
        }
        if (INTEGER_TYPE.equals(type)) {
            return this.toIntegerHolder(obj);
        }
        if (BOOLEAN_TYPE.equals(type)) {
            return this.toBooleanHolder(obj);
        }
        if (DATE_TYPE.equals(type)) {
            return this.toDateHolder(obj);
        }
        if (DATETIME_TYPE.equals(type)) {
            return this.toDatetimeHolder(obj);
        }
        throw new HyperonRuntimeException("Unsupported conversion for type: [" + type + "]");
    }

    public Object cast(Object obj, String type) {
        switch (type) {
            case "string": {
                return this.getString(obj);
            }
            case "integer": {
                return this.getLong(obj);
            }
            case "number": {
                return this.getDecimal(obj);
            }
            case "boolean": {
                return this.toBooleanHolder(obj).getBoolean();
            }
            case "date": {
                return this.getDate(obj);
            }
            case "datetime": {
                return this.getDatetime(obj);
            }
        }
        throw new HyperonRuntimeException("Type not supported: " + type);
    }

    public Type<? extends ValueHolder> getType(Class<? extends ValueHolder> holderClass) {
        String type;
        switch (type = HOLDER_TO_TYPE.get(holderClass)) {
            case "string": {
                return this.getStringType();
            }
            case "number": {
                return this.getNumberType();
            }
            case "integer": {
                return this.getIntegerType();
            }
            case "boolean": {
                return this.getBooleanType();
            }
            case "date": {
                return this.getDateType();
            }
            case "datetime": {
                return this.getDatetimeType();
            }
        }
        throw new HyperonRuntimeException("Unsupported holder class: " + holderClass);
    }

    public ValueHolder toHolder(Object obj, Class holderClass) {
        if (NULL_VALUE.equals(obj)) {
            return HOLDER_TO_NULL.get(holderClass);
        }
        return this.toHolder(obj, HOLDER_TO_TYPE.get(holderClass));
    }

    public StringType getStringType() {
        return HyperonContext.getStringType();
    }

    public NumberType getNumberType() {
        return HyperonContext.getNumberType();
    }

    public IntegerType getIntegerType() {
        return HyperonContext.getIntegerType();
    }

    public BooleanType getBooleanType() {
        return HyperonContext.getBooleanType();
    }

    public DateType getDateType() {
        return HyperonContext.getDateType();
    }

    public DatetimeType getDatetimeType() {
        return HyperonContext.getDatetimeType();
    }

    private Object unwrap(Object obj) {
        if (obj instanceof ValueHolder) {
            return this.unwrap((ValueHolder)obj);
        }
        return obj;
    }

    private Object unwrap(ValueHolder holder) {
        return holder != null ? holder.getValue() : null;
    }

    private <H extends ValueHolder> H convert(Object obj, Type<H> type) {
        return type.convert(this.unwrap(obj));
    }

    static {
        HashMap<Class<DateHolder>, Object> map = new HashMap<Class<DateHolder>, Object>();
        map.put(NumberHolder.class, NUMBER_TYPE);
        map.put(IntegerHolder.class, INTEGER_TYPE);
        map.put(StringHolder.class, STRING_TYPE);
        map.put(BooleanHolder.class, BOOLEAN_TYPE);
        map.put(DateHolder.class, DATE_TYPE);
        map.put(DatetimeHolder.class, DATETIME_TYPE);
        HOLDER_TO_TYPE = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put(NumberHolder.class, new NumberHolder(null));
        map.put(IntegerHolder.class, new IntegerHolder(null));
        map.put(StringHolder.class, new StringHolder(null));
        map.put(BooleanHolder.class, new BooleanHolder(null));
        map.put(DateHolder.class, new DateHolder(null));
        HOLDER_TO_NULL = Collections.unmodifiableMap(map);
    }
}

