/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.helper;

import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.alias.LevelMapper;
import pl.decerto.hyperon.runtime.model.MpLevel;
import pl.decerto.hyperon.runtime.model.MpParameter;
import pl.decerto.hyperon.runtime.model.MpParameterEntry;

public class MpHelper {
    public static final int MAX_LEVELS = 8;

    public MpParameterEntry createEntry(MpParameter p, String ... columns) {
        return this.createEntry(p.getLevelCount(), columns);
    }

    public MpParameterEntry createEntry(int levelCnt, String ... columns) {
        String[] levels = columns;
        int colCnt = columns.length;
        if (levelCnt > colCnt) {
            levels = new String[levelCnt];
            System.arraycopy(columns, 0, levels, 0, colCnt - 1);
            String varCell = columns[colCnt - 1];
            if (varCell != null) {
                String[] varLevel = EngineUtil.split(varCell, ';');
                int i = colCnt - 1;
                for (int j = 0; i < levelCnt && j < varLevel.length; ++i, ++j) {
                    levels[i] = varLevel[j];
                }
            }
        }
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = this.unify(levels[i]);
        }
        return new MpParameterEntry(levels);
    }

    public MpParameterEntry createEntry(LevelMapper mapper, String ... columns) {
        int sourceLevelCnt = mapper.getMasterLevelCnt();
        MpParameterEntry entry = this.createEntry(sourceLevelCnt, columns);
        entry.applyLevelMapper(mapper);
        return entry;
    }

    public MpParameterEntry createEntry(String ... cells) {
        return new MpParameterEntry(this.normalize(cells));
    }

    public String[] normalize(String ... cells) {
        int cnt = cells.length;
        String lastCell = cells[cnt - 1];
        if (lastCell == null || !lastCell.contains(";")) {
            return cells;
        }
        String[] varLevel = EngineUtil.split(lastCell, ';');
        String[] all = new String[cnt - 1 + varLevel.length];
        System.arraycopy(cells, 0, all, 0, cnt - 1);
        System.arraycopy(varLevel, 0, all, cnt - 1, varLevel.length);
        return all;
    }

    public String[] toDatabaseColumns(String[] logicalCells, int max) {
        if (logicalCells.length < max) {
            return logicalCells;
        }
        String[] cols = new String[max];
        System.arraycopy(logicalCells, 0, cols, 0, max - 1);
        cols[max - 1] = StringUtils.join((Object[])Arrays.copyOfRange(logicalCells, max - 1, logicalCells.length), (char)';') + ";%";
        return cols;
    }

    public String[] toDatabaseColumns(String[] logicalCells) {
        return this.toDatabaseColumns(logicalCells, 8);
    }

    public String[] ensureLength(String[] row, int length) {
        if (row.length < length) {
            String[] r = new String[length];
            System.arraycopy(row, 0, r, 0, row.length);
            return r;
        }
        return row;
    }

    public MpParameter copyDefinition(MpParameter src) {
        MpParameter p = new MpParameter();
        p.setId(src.getId());
        p.setName(src.getName());
        p.setInputLevels(src.getInputLevels());
        p.setNullable(src.isNullable());
        p.setCacheable(src.isCacheable());
        p.setArraySeparator(src.getArraySeparator());
        p.setSort(src.getSort());
        p.setLastUpdate(src.getLastUpdate());
        for (int i = 0; i < src.getLevelCount(); ++i) {
            MpLevel level = src.getLevel(i);
            p.addLevel(level.copy());
        }
        p.setEntriesCount(src.getEntries().size());
        p.setMid(src.getMid());
        p.setSlave(src.isSlave());
        p.setMasterName(src.getMasterName());
        p.setDistinct(src.isDistinct());
        p.setExternalSource(src.isExternalSource());
        p.setExternalInMemQuery(src.getExternalInMemQuery());
        p.setExternalNonMemQuery(src.getExternalNonMemQuery());
        p.setExternalDataSource(src.getExternalDataSource());
        p.setAutoRefresh(src.isAutoRefresh());
        p.setAutoRefreshPeriod(src.getAutoRefreshPeriod());
        p.setLoadedAt(src.getLoadedAt());
        p.postprocess();
        return p;
    }

    public String createInListPattern(int n) {
        return StringUtils.repeat((String)"?", (String)",", (int)n);
    }

    public String unify(String str) {
        return StringUtils.isBlank((CharSequence)str) ? null : str;
    }
}

