/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.function.argument;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Stream;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.date.DateType;
import org.smartparam.engine.types.number.NumberType;
import org.smartparam.engine.types.string.StringType;
import pl.decerto.hyperon.runtime.function.argument.InvalidFunctionArgumentDataTypeException;
import pl.decerto.hyperon.runtime.type.BooleanType;
import pl.decerto.hyperon.runtime.type.IntegerType;

public enum FunctionArgumentDataType {
    BOOLEAN("BOOLEAN", Boolean.class, new BooleanType()),
    INTEGER("INTEGER", Integer.class, new IntegerType()),
    BIG_DECIMAL("BIG_DECIMAL", BigDecimal.class, new NumberType()),
    DATE("DATE", Date.class, new DateType()),
    STRING("STRING", String.class, new StringType()),
    OBJECT("OBJECT", Object.class, null),
    SPECIFIED_CLASS("SPECIFIED_CLASS", Object.class, null),
    EXTERNAL_CLASS("EXTERNAL_CLASS", Object.class, null);

    public static final Set<String> COMPLEX_DATA_TYPES_NAMES;
    private final String name;
    private final Class<?> preferredClazz;
    private final Type<?> type;

    public static FunctionArgumentDataType of(String name) {
        return Stream.of(FunctionArgumentDataType.values()).filter(value -> value.getName().equals(name)).findFirst().orElseThrow(() -> new InvalidFunctionArgumentDataTypeException(String.format("Invalid function argument data type name passed: %s.", name)));
    }

    public String getName() {
        return this.name;
    }

    public Class<?> getPreferredClazz() {
        return this.preferredClazz;
    }

    public Type<?> getType() {
        return this.type;
    }

    private FunctionArgumentDataType(String name, Class<?> preferredClazz, Type<?> type) {
        this.name = name;
        this.preferredClazz = preferredClazz;
        this.type = type;
    }

    static {
        HashSet<String> complexDataTypesNames = new HashSet<String>();
        complexDataTypesNames.add(OBJECT.getName());
        complexDataTypesNames.add(SPECIFIED_CLASS.getName());
        complexDataTypesNames.add(EXTERNAL_CLASS.getName());
        COMPLEX_DATA_TYPES_NAMES = Collections.unmodifiableSet(complexDataTypesNames);
    }
}

