/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.distinct;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.output.ParamValueImpl;
import org.smartparam.engine.core.parameter.ParameterEntry;
import pl.decerto.hyperon.runtime.distinct.DefaultHashStrategy;
import pl.decerto.hyperon.runtime.distinct.HashStrategy;
import pl.decerto.hyperon.runtime.model.MpParameter;

public class DistinctFilter {
    private static final Logger log = LoggerFactory.getLogger(DistinctFilter.class);
    private final HashStrategy hashStrategy;

    public DistinctFilter() {
        this.hashStrategy = new DefaultHashStrategy();
    }

    public DistinctFilter(HashStrategy hashStrategy) {
        this.hashStrategy = hashStrategy;
    }

    public void filter(MpParameter p) {
        Collection<ParameterEntry> entries = p.getEntries();
        int size = entries.size();
        ArrayList<ParameterEntry> unique = new ArrayList<ParameterEntry>(size);
        HashMap map = new HashMap(DistinctFilter.capacityFor(size));
        for (ParameterEntry e : entries) {
            int h = this.hashStrategy.hash(e);
            ArrayList<ParameterEntry> list = (ArrayList<ParameterEntry>)map.get(h);
            if (list == null) {
                list = new ArrayList<ParameterEntry>(1);
                list.add(e);
                map.put(h, list);
            } else {
                if (DistinctFilter.contains(e, (List<ParameterEntry>)list)) continue;
                list.add(e);
            }
            unique.add(e);
        }
        if (unique.size() != size) {
            log.trace("rejected duplicates: {} -> {}", (Object)size, (Object)unique.size());
            entries.clear();
            entries.addAll(unique);
        }
    }

    public ParamValue filter(ParamValue pv) {
        if (pv.size() <= 1) {
            return pv;
        }
        int size = pv.size();
        ArrayList<MultiValue> unique = new ArrayList<MultiValue>(size);
        HashMap map = new HashMap(DistinctFilter.capacityFor(size));
        for (int i = 0; i < size; ++i) {
            MultiValue row = pv.row(i);
            int h = this.hashStrategy.hash(row);
            ArrayList<MultiValue> list = (ArrayList<MultiValue>)map.get(h);
            if (list == null) {
                list = new ArrayList<MultiValue>(1);
                list.add(row);
                map.put(h, list);
            } else {
                if (DistinctFilter.contains(row, (List<MultiValue>)list)) continue;
                list.add(row);
            }
            unique.add(row);
        }
        if (unique.size() != size) {
            return new ParamValueImpl(unique.toArray(new MultiValue[0]));
        }
        return pv;
    }

    private static int capacityFor(int n) {
        return (int)((float)n / 0.75f) + 1;
    }

    public static boolean contains(ParameterEntry e, List<ParameterEntry> others) {
        for (ParameterEntry other : others) {
            if (!Arrays.equals(e.getLevels(), other.getLevels())) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(MultiValue row, List<MultiValue> others) {
        for (MultiValue other : others) {
            if (!row.equals(other)) continue;
            return true;
        }
        return false;
    }

    public HashStrategy getHashStrategy() {
        return this.hashStrategy;
    }
}

