/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.samples.iterator;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import pl.decerto.hyperon.mp.simulation.samples.RangeBasedSamples;

abstract class BaseRangeIterator<V>
implements Iterator<V> {
    protected RangeBasedSamples<V> samples;
    protected V current;

    BaseRangeIterator(RangeBasedSamples<V> sampler) {
        this.samples = sampler;
    }

    @Override
    public void remove() {
    }

    @Override
    public V next() {
        if (Objects.isNull(this.current)) {
            this.current = this.samples.getMin();
            return this.current;
        }
        if (this.hasNext()) {
            this.current = this.computeNext(this.current, this.samples.getStep());
            return this.current;
        }
        throw new NoSuchElementException();
    }

    @Override
    public boolean hasNext() {
        return this.compare(this.computeNext(this.current, this.samples.getStep()), this.samples.getMax()) < 1;
    }

    protected abstract V computeNext(V var1, BigDecimal var2);

    protected abstract int compare(V var1, V var2);
}

