/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.result;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.result.FundResult;

public class SuspenseAccountResult {
    private String name;
    private BigDecimal totalPaidInPremiumAmount = BigDecimal.ZERO;
    private BigDecimal paidInPremiumAmount = BigDecimal.ZERO;
    private BigDecimal amountToInvest = BigDecimal.ZERO;
    private Map<String, FundResult> funds;
    private List<CollectedCharge> charges;
    private Map<String, BigDecimal> chargedAmountPerPhase;
    private BigDecimal surrenderCharge;
    private BigDecimal surrenderValue;

    public SuspenseAccountResult(String name) {
        this.name = name;
        this.funds = new LinkedHashMap<String, FundResult>();
        this.chargedAmountPerPhase = new LinkedHashMap<String, BigDecimal>();
        this.charges = new ArrayList<CollectedCharge>();
    }

    public void addFundResult(FundResult fundResult) {
        this.funds.put(fundResult.getCode(), fundResult);
    }

    public FundResult getFundResult(String code) {
        return this.funds.get(code);
    }

    public void addCollectedCharges(List<CollectedCharge> charges) {
        this.charges.addAll(charges);
    }

    public void addCollectedCharge(CollectedCharge charge) {
        this.charges.add(charge);
    }

    public Collection<FundResult> getFundResults() {
        return this.funds.values();
    }

    public Collection<CollectedCharge> getCollectedCharges() {
        return this.charges;
    }

    public String getName() {
        return this.name;
    }

    public BigDecimal getTotalPaidInPremiumAmount() {
        return this.totalPaidInPremiumAmount;
    }

    public BigDecimal getPaidInPremiumAmount() {
        return this.paidInPremiumAmount;
    }

    public BigDecimal getAmountToInvest() {
        return this.amountToInvest;
    }

    public Map<String, FundResult> getFunds() {
        return this.funds;
    }

    public List<CollectedCharge> getCharges() {
        return this.charges;
    }

    public Map<String, BigDecimal> getChargedAmountPerPhase() {
        return this.chargedAmountPerPhase;
    }

    public BigDecimal getSurrenderCharge() {
        return this.surrenderCharge;
    }

    public BigDecimal getSurrenderValue() {
        return this.surrenderValue;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setTotalPaidInPremiumAmount(BigDecimal totalPaidInPremiumAmount) {
        this.totalPaidInPremiumAmount = totalPaidInPremiumAmount;
    }

    public void setPaidInPremiumAmount(BigDecimal paidInPremiumAmount) {
        this.paidInPremiumAmount = paidInPremiumAmount;
    }

    public void setAmountToInvest(BigDecimal amountToInvest) {
        this.amountToInvest = amountToInvest;
    }

    public void setFunds(Map<String, FundResult> funds) {
        this.funds = funds;
    }

    public void setCharges(List<CollectedCharge> charges) {
        this.charges = charges;
    }

    public void setChargedAmountPerPhase(Map<String, BigDecimal> chargedAmountPerPhase) {
        this.chargedAmountPerPhase = chargedAmountPerPhase;
    }

    public void setSurrenderCharge(BigDecimal surrenderCharge) {
        this.surrenderCharge = surrenderCharge;
    }

    public void setSurrenderValue(BigDecimal surrenderValue) {
        this.surrenderValue = surrenderValue;
    }
}

