/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.result;

import java.math.BigDecimal;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import pl.decerto.hyperon.mp.simulation.life.invest.result.SuspenseAccountResult;

public class MonthlyResult {
    private int monthNumber;
    private BigDecimal paidInPremiumAmount = BigDecimal.ZERO;
    private BigDecimal totalPaidInPremiumAmount = BigDecimal.ZERO;
    private BigDecimal totalCapital = BigDecimal.ZERO;
    private BigDecimal surrender = BigDecimal.ZERO;
    private Map<String, SuspenseAccountResult> suspenseAccountResults;

    public MonthlyResult(int monthNumber) {
        this.monthNumber = monthNumber;
        this.suspenseAccountResults = new LinkedHashMap<String, SuspenseAccountResult>();
    }

    public void addSuspenseAccountResult(SuspenseAccountResult accountResult) {
        this.suspenseAccountResults.put(accountResult.getName(), accountResult);
    }

    public SuspenseAccountResult getAccountResult(String name) {
        return this.suspenseAccountResults.get(name);
    }

    public Collection<SuspenseAccountResult> getSuspenseAccountResults() {
        return this.suspenseAccountResults.values();
    }

    public int getMonthNumber() {
        return this.monthNumber;
    }

    public BigDecimal getPaidInPremiumAmount() {
        return this.paidInPremiumAmount;
    }

    public BigDecimal getTotalPaidInPremiumAmount() {
        return this.totalPaidInPremiumAmount;
    }

    public BigDecimal getTotalCapital() {
        return this.totalCapital;
    }

    public BigDecimal getSurrender() {
        return this.surrender;
    }

    public void setMonthNumber(int monthNumber) {
        this.monthNumber = monthNumber;
    }

    public void setPaidInPremiumAmount(BigDecimal paidInPremiumAmount) {
        this.paidInPremiumAmount = paidInPremiumAmount;
    }

    public void setTotalPaidInPremiumAmount(BigDecimal totalPaidInPremiumAmount) {
        this.totalPaidInPremiumAmount = totalPaidInPremiumAmount;
    }

    public void setTotalCapital(BigDecimal totalCapital) {
        this.totalCapital = totalCapital;
    }

    public void setSurrender(BigDecimal surrender) {
        this.surrender = surrender;
    }

    public void setSuspenseAccountResults(Map<String, SuspenseAccountResult> suspenseAccountResults) {
        this.suspenseAccountResults = suspenseAccountResults;
    }
}

