/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.params;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.decerto.hyperon.mp.simulation.life.invest.params.CapitalControl;
import pl.decerto.hyperon.mp.simulation.life.invest.params.SimulationVariant;
import pl.decerto.hyperon.mp.simulation.life.invest.params.SuspenseAccountDefinition;
import pl.decerto.hyperon.runtime.core.HyperonContext;

public class PolicyValueSimulationParameters {
    private String simulationCode;
    private int insuranceTermInMonths;
    private int insuredAgeAtEntry;
    private BigDecimal sumAssured;
    private String productCode;
    private SimulationVariant simulationVariant;
    private int insuredCount;
    private String algorithmParameterName = "simulation.life.algorithm.standard";
    private List<SuspenseAccountDefinition> suspenseAccountDefinitions;
    private String fundsParams;
    private Map<String, String> contextElements = new HashMap<String, String>();
    private String algorithmFunctionName = null;
    private String preProcessFunctionName = null;
    private HyperonContext context;
    private CapitalControl capitalControl = CapitalControl.NO_CONTROL;

    public PolicyValueSimulationParameters() {
        this.suspenseAccountDefinitions = new ArrayList<SuspenseAccountDefinition>();
    }

    public Map<String, String> getContextElements() {
        return new HashMap<String, String>(this.contextElements);
    }

    public void setAlgorithmFunctionName(String algorithmFunctionName) {
        this.algorithmFunctionName = algorithmFunctionName;
        this.algorithmParameterName = null;
    }

    public void addContextElement(String key, String value) {
        if (this.contextElements == null) {
            this.contextElements = new HashMap<String, String>();
        }
        this.contextElements.put(key, value);
    }

    public void addSuspenseAccountDefinition(SuspenseAccountDefinition suspenseAccountDefinition) {
        if (this.suspenseAccountDefinitions == null) {
            this.suspenseAccountDefinitions = new ArrayList<SuspenseAccountDefinition>();
        }
        this.suspenseAccountDefinitions.add(suspenseAccountDefinition);
    }

    public static PolicyValueSimulationParameters newSimulationParameters() {
        return new PolicyValueSimulationParameters();
    }

    public PolicyValueSimulationParameters withInsuranceTermInMonths(int months) {
        this.insuranceTermInMonths = months;
        return this;
    }

    public PolicyValueSimulationParameters withInsuredCount(int insuredCount) {
        this.insuredCount = insuredCount;
        return this;
    }

    public PolicyValueSimulationParameters withProductCode(String productCode) {
        this.productCode = productCode;
        return this;
    }

    public PolicyValueSimulationParameters withSimulationCode(String simulationCode) {
        this.simulationCode = simulationCode;
        return this;
    }

    public PolicyValueSimulationParameters withSimulationVariant(SimulationVariant simulationVariant) {
        this.simulationVariant = simulationVariant;
        return this;
    }

    public PolicyValueSimulationParameters withSumAssured(BigDecimal sumAssured) {
        this.sumAssured = sumAssured;
        return this;
    }

    public PolicyValueSimulationParameters withInsuredAgeAtEntry(int innsuretAgeAtEntry) {
        this.insuredAgeAtEntry = innsuretAgeAtEntry;
        return this;
    }

    public PolicyValueSimulationParameters withSuspenseAcountDefinition(SuspenseAccountDefinition suspenseAccountDefinition) {
        this.suspenseAccountDefinitions.add(suspenseAccountDefinition);
        return this;
    }

    public PolicyValueSimulationParameters withSuspenseAcountDefinitions(List<SuspenseAccountDefinition> suspenseAccountDefinitions) {
        this.suspenseAccountDefinitions.addAll(suspenseAccountDefinitions);
        return this;
    }

    public PolicyValueSimulationParameters withAlgorithmParameterName(String algorithmParameterName) {
        this.algorithmParameterName = algorithmParameterName;
        return this;
    }

    public PolicyValueSimulationParameters withFundsParameterName(String fundsParameterName) {
        this.fundsParams = fundsParameterName;
        return this;
    }

    public PolicyValueSimulationParameters withContextElements(Map<String, String> contextElements) {
        this.contextElements = contextElements;
        return this;
    }

    public PolicyValueSimulationParameters withAlgorithmFunctionName(String algorithmFunction) {
        this.algorithmFunctionName = algorithmFunction;
        return this;
    }

    public PolicyValueSimulationParameters withPreProcessFunctionName(String preProcessFunction) {
        this.preProcessFunctionName = preProcessFunction;
        return this;
    }

    public PolicyValueSimulationParameters withContext(HyperonContext context) {
        this.context = context;
        return this;
    }

    public PolicyValueSimulationParameters withCapitalControl(CapitalControl capitalControl) {
        this.capitalControl = capitalControl;
        return this;
    }

    public String getSimulationCode() {
        return this.simulationCode;
    }

    public int getInsuranceTermInMonths() {
        return this.insuranceTermInMonths;
    }

    public int getInsuredAgeAtEntry() {
        return this.insuredAgeAtEntry;
    }

    public BigDecimal getSumAssured() {
        return this.sumAssured;
    }

    public String getProductCode() {
        return this.productCode;
    }

    public SimulationVariant getSimulationVariant() {
        return this.simulationVariant;
    }

    public int getInsuredCount() {
        return this.insuredCount;
    }

    public String getAlgorithmParameterName() {
        return this.algorithmParameterName;
    }

    public List<SuspenseAccountDefinition> getSuspenseAccountDefinitions() {
        return this.suspenseAccountDefinitions;
    }

    public String getFundsParams() {
        return this.fundsParams;
    }

    public String getAlgorithmFunctionName() {
        return this.algorithmFunctionName;
    }

    public String getPreProcessFunctionName() {
        return this.preProcessFunctionName;
    }

    public HyperonContext getContext() {
        return this.context;
    }

    public CapitalControl getCapitalControl() {
        return this.capitalControl;
    }
}

