/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.params;

import java.io.Serializable;
import java.math.BigDecimal;
import pl.decerto.hyperon.mp.simulation.life.invest.params.Frequency;

public class PaymentDefinition
implements Serializable {
    private static final long serialVersionUID = 1L;
    private BigDecimal amount;
    private String paymentSource;

    public PaymentDefinition() {
        this(BigDecimal.ZERO);
    }

    protected PaymentDefinition(PaymentDefinition definition) {
        this.amount = definition.getAmount();
        this.paymentSource = definition.getPaymentSource();
    }

    protected PaymentDefinition(BigDecimal amount) {
        this.amount = amount;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public String getPaymentSource() {
        return this.paymentSource;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setPaymentSource(String paymentSource) {
        this.paymentSource = paymentSource;
    }

    public static class IrregularPaymentDefinition
    extends PaymentDefinition {
        private static final long serialVersionUID = 1L;
        private Integer monthNumber;

        public IrregularPaymentDefinition() {
            this(0);
        }

        public IrregularPaymentDefinition(Integer monthNumber) {
            this.monthNumber = monthNumber;
        }

        public IrregularPaymentDefinition(IrregularPaymentDefinition definition) {
            super(definition);
            this.monthNumber = definition.getMonthNumber();
        }

        public Integer getMonthNumber() {
            return this.monthNumber;
        }

        public void setMonthNumber(Integer monthNumber) {
            this.monthNumber = monthNumber;
        }
    }

    public static class RegularPaymentDefinition
    extends PaymentDefinition {
        private static final long serialVersionUID = 1L;
        private Frequency frequency;

        public RegularPaymentDefinition() {
            this(Frequency.MC_12);
        }

        public RegularPaymentDefinition(Frequency frequency) {
            this.frequency = frequency;
        }

        public RegularPaymentDefinition(RegularPaymentDefinition definition) {
            super(definition);
            this.frequency = definition.getFrequency();
        }

        public Frequency getFrequency() {
            return this.frequency;
        }

        public void setFrequency(Frequency frequency) {
            this.frequency = frequency;
        }

        public String getFrequencyName() {
            switch (this.frequency) {
                case MC_12: {
                    return "monthly";
                }
                case QC_4: {
                    return "quarterly";
                }
                case SC_2: {
                    return "half-yearly";
                }
                case AC_1: {
                    return "annual";
                }
            }
            return "other";
        }
    }
}

