/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.params;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class FundDefinition {
    private String code;
    private String type;
    private BigDecimal split;
    private String name;
    private Map<String, BigDecimal> yearRateReturns;

    public FundDefinition(String code, String type, BigDecimal split) {
        this.code = code;
        this.type = type;
        this.split = split;
        this.yearRateReturns = new HashMap<String, BigDecimal>();
    }

    public FundDefinition(String code, String type, BigDecimal split, String name) {
        this(code, type, split);
        this.name = name;
    }

    public FundDefinition(String type) {
        this("", type, BigDecimal.ZERO);
    }

    public FundDefinition() {
        this("", "FUND", BigDecimal.ZERO);
    }

    public void addYearRateReturn(String monthFrom, BigDecimal value) {
        this.yearRateReturns.put(monthFrom, value);
    }

    public String[] getMonthsWhenRateChange() {
        ArrayList<String> months = new ArrayList<String>(this.yearRateReturns.keySet());
        months.sort((o1, o2) -> {
            Integer i1 = Integer.valueOf(o1);
            Integer i2 = Integer.valueOf(o2);
            return i1.compareTo(i2);
        });
        return months.toArray(new String[0]);
    }

    public BigDecimal getYearRateReturnFromMonth(String month) {
        return this.yearRateReturns.get(month);
    }

    public String getCode() {
        return this.code;
    }

    public String getType() {
        return this.type;
    }

    public BigDecimal getSplit() {
        return this.split;
    }

    public String getName() {
        return this.name;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setSplit(BigDecimal split) {
        this.split = split;
    }

    public void setName(String name) {
        this.name = name;
    }
}

