/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.charge;

import java.math.BigDecimal;
import java.util.Map;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.params.CapitalControl;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class PaymentChargeCollector {
    public void collectCharge(SimulationLifeContext context) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        for (Map.Entry<String, BigDecimal> sourceEntry : account.getAmountToInvestPerSource().entrySet()) {
            context.setPaymenSource(sourceEntry.getKey());
            BigDecimal premiumAmount = sourceEntry.getValue();
            if (!SimulationMathematicalFunctions.greaterThanZero(premiumAmount)) continue;
            this.collectChargePerSource(context, sourceEntry.getKey(), premiumAmount, context.getCurrentChargeDefinition());
        }
        context.setPaymenSource(null);
    }

    private void collectChargePerSource(SimulationLifeContext context, String source, BigDecimal amount, ChargeDefinition chargeDefinition) {
        InvestPolicyValueSimulationContext.SuspenseAccount account = context.getCurrentAccount();
        ChargeValueDefinition chargeValue = ChargeValueDefinition.getChargeValueDefinition(context);
        BigDecimal chargeAmount = chargeValue.calculateAmount(amount);
        CapitalControl capitalControl = context.getSimulationData().getCapitalControl();
        if (SimulationMathematicalFunctions.greaterThanZero(chargeAmount)) {
            if (capitalControl != CapitalControl.NO_CONTROL && chargeAmount.compareTo(amount) > 0) {
                switch (capitalControl) {
                    case NO_DEBT: {
                        chargeAmount = amount;
                        break;
                    }
                    case EXCEPTION_AT_DEBT: {
                        throw new HyperonRuntimeException("Charge " + chargeDefinition.getCode() + " in amount " + chargeAmount + " greater then amount " + amount + " for account " + account.getCode());
                    }
                }
            }
            BigDecimal reducedPayment = SimulationMathematicalFunctions.subtract(amount, chargeAmount);
            account.getAmountToInvestPerSource().put(source, reducedPayment);
            CollectedCharge charge = new CollectedCharge(account.getCode(), chargeDefinition, chargeValue).withChargedAmount(chargeAmount);
            charge.setPhase(context.getChargePhase());
            account.addCollectedCharge(charge);
        }
    }
}

