/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.charge;

import java.math.BigDecimal;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;

public class CollectedCharge {
    private String accountCode;
    private String fundCode;
    private BigDecimal chargedUnits;
    private BigDecimal chargedAmount;
    private ChargeValueDefinition chargeValueDefinition;
    private ChargeDefinition chargeDefinition;
    private String phase;

    public CollectedCharge(String accountCode, ChargeDefinition chargeDefinition, ChargeValueDefinition chargeValueDefinition) {
        this.accountCode = accountCode;
        this.chargeValueDefinition = chargeValueDefinition;
        this.chargeDefinition = chargeDefinition;
        this.chargedUnits = BigDecimal.ZERO;
        this.chargedAmount = BigDecimal.ZERO;
    }

    public CollectedCharge withChargedAmount(BigDecimal chargedAmount) {
        this.chargedAmount = chargedAmount;
        return this;
    }

    public CollectedCharge withChargedAmount(String fundCode, BigDecimal chargedAmount) {
        this.fundCode = fundCode;
        this.chargedAmount = chargedAmount;
        return this;
    }

    public CollectedCharge withChargedUnits(String fundCode, BigDecimal chargedUnits) {
        this.fundCode = fundCode;
        this.chargedUnits = chargedUnits;
        return this;
    }

    public String getName() {
        return this.chargeDefinition.getName();
    }

    public String getCode() {
        return this.chargeDefinition.getCode();
    }

    public String getAccountCode() {
        return this.accountCode;
    }

    public String getFundCode() {
        return this.fundCode;
    }

    public BigDecimal getChargedUnits() {
        return this.chargedUnits;
    }

    public BigDecimal getChargedAmount() {
        return this.chargedAmount;
    }

    public ChargeValueDefinition getChargeValueDefinition() {
        return this.chargeValueDefinition;
    }

    public ChargeDefinition getChargeDefinition() {
        return this.chargeDefinition;
    }

    public String getPhase() {
        return this.phase;
    }

    public void setPhase(String phase) {
        this.phase = phase;
    }
}

