/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.runtime.core.HyperonContext;

public class SimulationLifeContext
extends HyperonContext {
    private static final Logger log = LoggerFactory.getLogger(SimulationLifeContext.class);
    private final SimulationLife simulationData;
    private InvestPolicyValueSimulationContext.SuspenseAccount currentAccount;
    private InvestPolicyValueSimulationContext.Fund currentFund;
    private String currentPhase;
    private ChargeDefinition currentChargeDefinition;
    private Map<String, String> additionalContextPaths;
    private Set<String> missingPaths;
    private Set<String> usedAdditionlPaths;
    private final String simulationId;
    private List<String> collectedMessages = new ArrayList<String>();
    private Set<String> simulationChargePhaseInOrder;
    private String paymentSource;

    public SimulationLifeContext(SimulationLife simulationData, Map<String, String> additionaContextPaths, String simulationId) {
        super(new Object[0]);
        this.simulationData = simulationData;
        this.additionalContextPaths = additionaContextPaths;
        this.missingPaths = new HashSet<String>();
        this.usedAdditionlPaths = new HashSet<String>();
        this.simulationId = simulationId;
    }

    @Override
    public Object get(String path) {
        switch (path) {
            case "simulationLife.productCode": {
                return this.simulationData.getProductCode();
            }
            case "simulationLife.accountCode": {
                return this.currentAccount == null ? null : this.currentAccount.getCode();
            }
            case "simulationLife.fundCode": {
                return this.currentFund == null ? null : this.currentFund.getCode();
            }
            case "simulationLife.periodNumber": {
                return this.simulationData.getPeriodNumber();
            }
            case "simulationLife.simulationVariant": {
                return this.simulationData.getSimulationVariant().name();
            }
            case "simulationLife.phase": {
                return this.currentPhase;
            }
            case "simulationLife.paymentSource": {
                return this.paymentSource == null ? "*" : this.paymentSource;
            }
            case "simulationLife.chargeCode": {
                return this.currentChargeDefinition == null ? "*" : this.currentChargeDefinition.getCode();
            }
        }
        if (this.isAdditionalPath(path)) {
            this.usedAdditionlPaths.add(path);
            return this.additionalContextPaths.get(path);
        }
        if (!this.missingPaths.contains(path)) {
            this.missingPaths.add(path);
            log.warn("No data for path: {}", (Object)path);
        }
        return null;
    }

    @Override
    public HyperonContext set(String path, Object value) {
        if (value == null) {
            return this;
        }
        String mapValue = value instanceof String ? (String)value : value.toString();
        this.additionalContextPaths.put(path, mapValue);
        return this;
    }

    private boolean isAdditionalPath(String path) {
        return this.additionalContextPaths.get(path) != null;
    }

    public void setCurrentPhase(String currentPhase) {
        this.currentPhase = currentPhase;
        this.addSimulationChargePhase(currentPhase);
    }

    public void setCurrentAccount(InvestPolicyValueSimulationContext.SuspenseAccount account) {
        this.currentAccount = account;
        this.currentChargeDefinition = null;
        this.currentFund = null;
    }

    public String getChargePhase() {
        return this.currentPhase;
    }

    public String getChargeValueParameter() {
        return this.currentChargeDefinition.getChargeValueParameter();
    }

    public Set<String> getAndResetMissingPaths() {
        HashSet<String> result = new HashSet<String>(this.missingPaths);
        this.missingPaths = new HashSet<String>();
        return result;
    }

    public Set<String> getAndResetUsedAdditionlPaths() {
        HashSet<String> result = new HashSet<String>(this.usedAdditionlPaths);
        this.usedAdditionlPaths = new HashSet<String>();
        return result;
    }

    public void addMessage(String msg) {
        this.collectedMessages.add(msg);
    }

    public List<String> getCollectedMessages() {
        return Collections.unmodifiableList(this.collectedMessages);
    }

    public void setPaymenSource(String source) {
        this.paymentSource = source;
    }

    private void addSimulationChargePhase(String newPhase) {
        if (StringUtils.isBlank((CharSequence)newPhase)) {
            return;
        }
        if (this.simulationChargePhaseInOrder == null) {
            this.simulationChargePhaseInOrder = new LinkedHashSet<String>();
        }
        this.simulationChargePhaseInOrder.add(newPhase);
    }

    public SimulationLife getSimulationData() {
        return this.simulationData;
    }

    public InvestPolicyValueSimulationContext.SuspenseAccount getCurrentAccount() {
        return this.currentAccount;
    }

    public InvestPolicyValueSimulationContext.Fund getCurrentFund() {
        return this.currentFund;
    }

    public void setCurrentFund(InvestPolicyValueSimulationContext.Fund currentFund) {
        this.currentFund = currentFund;
    }

    public ChargeDefinition getCurrentChargeDefinition() {
        return this.currentChargeDefinition;
    }

    public void setCurrentChargeDefinition(ChargeDefinition currentChargeDefinition) {
        this.currentChargeDefinition = currentChargeDefinition;
    }

    public Map<String, String> getAdditionalContextPaths() {
        return this.additionalContextPaths;
    }

    public String getSimulationId() {
        return this.simulationId;
    }

    public Set<String> getSimulationChargePhaseInOrder() {
        return this.simulationChargePhaseInOrder;
    }
}

