/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeCollector;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.ChargeValueDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.api.Funds;
import pl.decerto.hyperon.mp.simulation.life.invest.api.Payment;
import pl.decerto.hyperon.mp.simulation.life.invest.api.PaymentData;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.TransferStatus;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.PaymentChargeCollector;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.RateReturnChargeCollector;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.StdUnitChargeToDebtCollector;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.UnitChargeToDebtCollector;
import pl.decerto.hyperon.mp.simulation.life.invest.params.FundDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.params.PolicyValueSimulationParameters;
import pl.decerto.hyperon.runtime.core.HyperonContext;

public class RhinoSimulationLife {
    public static final RhinoSimulationLife INSTANCE = new RhinoSimulationLife();

    private RhinoSimulationLife() {
    }

    public static void payIntoAccounts(HyperonContext context) {
        new Payment().payIntoAccounts((SimulationLifeContext)context);
    }

    public static void payIntoAccount(HyperonContext context, String account, String source, BigDecimal amount) {
        new Payment().payIntoAccount((SimulationLifeContext)context, account, source, amount);
    }

    public static void collectChargeForAccount(HyperonContext context, String parameterName) {
        new ChargeCollector().collectChargeForAccountOrFunds((SimulationLifeContext)context, parameterName, true);
    }

    public static void reducePaymentCharge(HyperonContext context) {
        new PaymentChargeCollector().collectCharge((SimulationLifeContext)context);
    }

    public static void calculateAmountToInvest(HyperonContext context) {
        new Funds().setAmountToInvest((SimulationLifeContext)context);
    }

    public static void calculateAnnualRateReturnA2(HyperonContext context) {
        new Funds().setAnnualRateReturnA2((SimulationLifeContext)context);
    }

    public static void calculateAnnualRateReturn(HyperonContext context, String parameterName) {
        new Funds().setAnnualRateReturn((SimulationLifeContext)context, parameterName, false);
    }

    public static void calculateAnnualRateReturnSqrt(HyperonContext context, String parameterName) {
        new Funds().setAnnualRateReturn((SimulationLifeContext)context, parameterName, true);
    }

    public static void setMonthlyEffectiveRateReturn(HyperonContext context, String accountCode, String fundCode, BigDecimal value) {
        new Funds().setMonthlyEffectiveRateReturn((SimulationLifeContext)context, accountCode, fundCode, value);
    }

    public static void buyUnits(HyperonContext context, String ... accountCode) {
        new Funds().buyUnits((SimulationLifeContext)context, accountCode);
    }

    public static void collectChargesForFunds(HyperonContext context, String parameterName) {
        new ChargeCollector().collectChargeForAccountOrFunds((SimulationLifeContext)context, parameterName, false);
    }

    public static void collectChargeForFundProporional(HyperonContext context, String account, String fund, BigDecimal amount, ChargeDefinition chargeDefinition) {
        new ChargeCollector().collectChargeForAccount((SimulationLifeContext)context, account, fund, amount, chargeDefinition);
    }

    public static void collectChargeForCurrentFundProporional(HyperonContext context, BigDecimal amount) {
        new ChargeCollector().collectChargeForAccount((SimulationLifeContext)context, amount);
    }

    public static void collectChargeForFundExact(HyperonContext context, String account, String fund, BigDecimal amount, ChargeDefinition chargeDefinition) {
        new ChargeCollector().collectChargeForFund((SimulationLifeContext)context, account, fund, amount, chargeDefinition);
    }

    public static void collectChargeForCurrentFundExact(HyperonContext context, BigDecimal amount) {
        new ChargeCollector().collectChargeForFund((SimulationLifeContext)context, amount);
    }

    public static void collectRateReturnCharge(HyperonContext context) {
        new RateReturnChargeCollector().collectCharge((SimulationLifeContext)context);
    }

    public static void collectUnitChargesBasedOnCapitalToDebt(HyperonContext context) {
        new UnitChargeToDebtCollector().collectChargeToDeptForFund((SimulationLifeContext)context);
    }

    public static void collectChargeFromDebt(HyperonContext context) {
        new ChargeCollector().collectChargeFromDebt((SimulationLifeContext)context);
    }

    public static void addChargeWithoutDeductionForAccount(HyperonContext context, String accountCode, ChargeDefinition chargeDefinition, ChargeValueDefinition valueDefinition) {
        if (valueDefinition == null) {
            return;
        }
        new ChargeCollector().addChargeWithoutDeduction((SimulationLifeContext)context, accountCode, null, chargeDefinition, valueDefinition, null);
    }

    public static void addChargeWithoutDeductionForFund(HyperonContext context, String accountCode, String fundCode, ChargeDefinition chargeDefinition, ChargeValueDefinition valueDefinition, BigDecimal chargedUnits) {
        if (valueDefinition == null) {
            return;
        }
        new ChargeCollector().addChargeWithoutDeduction((SimulationLifeContext)context, accountCode, fundCode, chargeDefinition, valueDefinition, chargedUnits);
    }

    public static void updateFundPricesAtMonthBeginning(HyperonContext context) {
        new Funds().updateFundPrices((SimulationLifeContext)context, false);
    }

    public static void updateFundPrices(HyperonContext context) {
        new Funds().updateFundPrices((SimulationLifeContext)context, true);
    }

    public static void collectUnitChargesBasedOnUnitsAvgToDebt(HyperonContext context) {
        new StdUnitChargeToDebtCollector().collectChargeToDeptForFund((SimulationLifeContext)context, true);
    }

    public static void collectUnitChargesBasedOnUnitsAvgToDeptExact(HyperonContext context) {
        new StdUnitChargeToDebtCollector().collectChargeToDeptForFund((SimulationLifeContext)context, false);
    }

    public static void calculateSurrender(HyperonContext context, String parameterName, String chargeCode) {
        new ChargeCollector().calculateSurrender((SimulationLifeContext)context, parameterName, chargeCode, false);
    }

    public static void calculateSurrenderBaseOnCapital(HyperonContext context, String parameterName, String chargeCode) {
        new ChargeCollector().calculateSurrender((SimulationLifeContext)context, parameterName, chargeCode, true);
    }

    public static void applyIndexation(HyperonContext context, String accountCode, String source, BigDecimal ratio) {
        new Payment().applyIndexation((SimulationLifeContext)context, accountCode, source, ratio);
    }

    public static void setChargePhase(HyperonContext context, String chargePhase) {
        ((SimulationLifeContext)context).setCurrentPhase(chargePhase == null ? "" : chargePhase);
    }

    public static void addLog(HyperonContext context, String message) {
        ((SimulationLifeContext)context).addMessage(message);
    }

    public static ChargeValueDefinition getChargeValueFromParameter(String parameterName, HyperonContext context) {
        return ChargeValueDefinition.getChargeValueDefinition((SimulationLifeContext)context, parameterName);
    }

    public static TransferStatus transfer(HyperonContext context, String accountFrom, String fundFrom, String accountTo, String fundTo, BigDecimal amount) {
        return new Funds().transfer((SimulationLifeContext)context, accountFrom, fundFrom, accountTo, fundTo, amount);
    }

    public static TransferStatus transferBasedOnDefinitionSplit(HyperonContext context, String accountFrom, String accountTo, BigDecimal amount) {
        return new Funds().transfer((SimulationLifeContext)context, accountFrom, accountTo, amount, Funds.FundsSplitType.ACCOUNT_DEFINITION_SPLIT);
    }

    public static TransferStatus transferBasedOnBalanceSplit(HyperonContext context, String accountFrom, String accountTo, BigDecimal amount) {
        return new Funds().transfer((SimulationLifeContext)context, accountFrom, accountTo, amount, Funds.FundsSplitType.ACCOUNT_BALANCE_SPLIT);
    }

    public static TransferStatus transferAllUnits(HyperonContext context, String accountFrom, String accountTo) {
        return new Funds().transfer((SimulationLifeContext)context, accountFrom, accountTo, null, Funds.FundsSplitType.ALL_UNITS);
    }

    public static PolicyValueSimulationParameters createPolicyValueSimulationParameters() {
        return new PolicyValueSimulationParameters();
    }

    public static FundDefinition createFundDefinition(String code, String type, BigDecimal split, String name) {
        return new FundDefinition(code, type, split, name);
    }

    public static List<ChargeDefinition> getChargeDefinitionFromParameter(String parameterName, HyperonContext context) {
        return ChargeDefinition.findCollectors(parameterName, (SimulationLifeContext)context);
    }

    public static BigDecimal getCapitalAtBeginning(HyperonContext context) {
        return RhinoSimulationLife.getCapitalAtBeginning(context, null);
    }

    public static BigDecimal getCapitalAtEnd(HyperonContext context) {
        return RhinoSimulationLife.getCapitalAtEnd(context, null);
    }

    public static BigDecimal getCapitalAtBeginning(HyperonContext context, String account) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        BigDecimal result = BigDecimal.ZERO;
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (account != null && !accountData.getCode().equals(account)) continue;
            result = result.add(accountData.calculateAccountCapitalAtBeginning());
        }
        return SimulationMathematicalFunctions.scale(result, 10);
    }

    public static BigDecimal getCapitalAtEnd(HyperonContext context, String account) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        BigDecimal result = BigDecimal.ZERO;
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (account != null && !accountData.getCode().equals(account)) continue;
            result = result.add(accountData.calculateCurrentAccountCapital());
        }
        return SimulationMathematicalFunctions.scale(result, 10);
    }

    public static BigDecimal getPaymentInPeriod(HyperonContext context) {
        return RhinoSimulationLife.getPaymentInPeriod(context, null);
    }

    public static BigDecimal getPaymentInPeriod(HyperonContext context, String account) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        BigDecimal result = BigDecimal.ZERO;
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (account != null && !accountData.getCode().equals(account)) continue;
            result = result.add(accountData.getMonthlyPaidInAmount());
        }
        return SimulationMathematicalFunctions.scale(result, 10);
    }

    public static BigDecimal getTotalPayment(HyperonContext context) {
        return RhinoSimulationLife.getTotalPayment(context, null);
    }

    public static BigDecimal getTotalPayment(HyperonContext context, String account) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        BigDecimal result = BigDecimal.ZERO;
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (account != null && !accountData.getCode().equals(account)) continue;
            result = result.add(accountData.calculateAmmountToInvestInPeriod(0, simulationData.getPeriodNumber(), null));
        }
        return SimulationMathematicalFunctions.scale(result, 10);
    }

    public static BigDecimal getPaymentInPeriod(HyperonContext context, String account, String source, int periodStart, int periodEnd) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        BigDecimal result = BigDecimal.ZERO;
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (account != null && !accountData.getCode().equals(account)) continue;
            result = result.add(accountData.calculateAmmountToInvestInPeriod(periodStart, periodEnd, source));
        }
        return SimulationMathematicalFunctions.scale(result, 10);
    }

    public static List<String> getAccountCodes(HyperonContext context) {
        ArrayList<String> result = new ArrayList<String>();
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            result.add(accountData.getCode());
        }
        return result;
    }

    public static List<String> getFundCodes(HyperonContext context, String account) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!account.equals(accountData.getCode())) continue;
            return accountData.getFundCodes();
        }
        return new ArrayList<String>();
    }

    public static BigDecimal getShareForFund(HyperonContext context, String account, String fund) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            InvestPolicyValueSimulationContext.Fund fundData;
            if (!account.equals(accountData.getCode()) || (fundData = accountData.getFund(fund)) == null) continue;
            BigDecimal totalUnits = accountData.getTotalUnits();
            return SimulationMathematicalFunctions.divide(fundData.getUnits(), totalUnits);
        }
        return BigDecimal.ZERO;
    }

    public static BigDecimal getMonthlyEffectiveRateReturn(HyperonContext context) {
        SimulationLifeContext simulationData = (SimulationLifeContext)context;
        return simulationData.getCurrentFund().getMonthlyEffectiveRateReturn();
    }

    public static BigDecimal getMonthlyRateReturnAsSqrtFromAnnual(HyperonContext context) {
        SimulationLifeContext simulationData = (SimulationLifeContext)context;
        return SimulationMathematicalFunctions.calculateMonthEffectiveRateReturn(simulationData.getCurrentFund().getAnnualRateReturn());
    }

    public static ChargeDefinition createChargeDefinition(String code, String name) {
        return new ChargeDefinition(code, name);
    }

    public static ChargeValueDefinition createChargeValueDefinition(String type, BigDecimal value) {
        return new ChargeValueDefinition(type, value);
    }

    public static BigDecimal getUnitsAtBeginning(HyperonContext context, String accountCode, String fundCode) {
        return new Funds().getUnitsAtBeginning((SimulationLifeContext)context, accountCode, fundCode);
    }

    public static BigDecimal getUnitsPrice(HyperonContext context, String accountCode, String fundCode) {
        return new Funds().getUnitsPrice((SimulationLifeContext)context, accountCode, fundCode);
    }

    public static List<PaymentData> getDeclaredPayments(HyperonContext context, String accountCode, boolean onlyRegular) {
        return new Payment().getDeclaredPayments((SimulationLifeContext)context, accountCode, onlyRegular);
    }

    public static List<InvestPolicyValueSimulationContext.FundCharge> getChargesFromDebt(HyperonContext context, String accountCode) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!accountCode.equals(accountData.getCode())) continue;
            return Collections.unmodifiableList(accountData.getDebt());
        }
        return Collections.unmodifiableList(new ArrayList());
    }

    public static List<CollectedCharge> getCollectedCharges(HyperonContext context, String accountCode) {
        SimulationLife simulationData = ((SimulationLifeContext)context).getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!accountCode.equals(accountData.getCode())) continue;
            return Collections.unmodifiableList(accountData.getCollectedCharges());
        }
        return Collections.unmodifiableList(new ArrayList());
    }
}

