/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.PaymentData;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.params.Frequency;
import pl.decerto.hyperon.mp.simulation.life.invest.params.PaymentDefinition;

public class Payment {
    public void payIntoAccounts(SimulationLifeContext simulationContext) {
        SimulationLife simulationData = simulationContext.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            this.resetAccountPaymentsData(account);
            this.payIntoAccount(simulationData.getPeriodNumber(), account, new BigDecimal[0]);
        }
    }

    public void payIntoAccount(SimulationLifeContext context, String account, String source, BigDecimal amount) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount accountData : simulationData.getAccounts()) {
            if (!accountData.getCode().equals(account)) continue;
            this.setPayment(simulationData.getPeriodNumber(), accountData, source, amount);
            return;
        }
    }

    public void applyIndexation(SimulationLifeContext context, String accountCode, String source, BigDecimal ratio) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (accountCode != null && !account.getCode().equals(accountCode)) continue;
            this.applyIndexation(account, source, ratio, simulationData.getPeriodNumber());
        }
    }

    public List<PaymentData> getDeclaredPayments(SimulationLifeContext context, String accountCode, boolean onlyRegular) {
        SimulationLife simulationData = context.getSimulationData();
        return this.sumPayments(accountCode, onlyRegular, simulationData);
    }

    private List<PaymentData> sumPayments(String accountCode, boolean onlyRegular, SimulationLife simulationData) {
        ArrayList<PaymentData> payments = new ArrayList<PaymentData>();
        Map<String, BigDecimal> paymentsByFrequency = this.getPaymentsByFrequency(accountCode, onlyRegular, simulationData);
        for (Map.Entry<String, BigDecimal> payment : paymentsByFrequency.entrySet()) {
            payments.add(new PaymentData(payment.getValue(), payment.getKey()));
        }
        return payments;
    }

    private Map<String, BigDecimal> getPaymentsByFrequency(String accountCode, boolean onlyRegular, SimulationLife simulationData) {
        HashMap<String, BigDecimal> paymentsByFrequency = new HashMap<String, BigDecimal>();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (!account.getCode().equals(accountCode)) continue;
            this.calulcatePayments(onlyRegular, paymentsByFrequency, account);
        }
        return paymentsByFrequency;
    }

    private void calulcatePayments(boolean onlyRegular, Map<String, BigDecimal> paymentsByFrequency, InvestPolicyValueSimulationContext.SuspenseAccount account) {
        for (PaymentDefinition definition : account.getPaymentDefinitions()) {
            if (definition instanceof PaymentDefinition.RegularPaymentDefinition && onlyRegular) {
                this.updatePayments(paymentsByFrequency, definition.getAmount(), ((PaymentDefinition.RegularPaymentDefinition)definition).getFrequencyName());
                continue;
            }
            if (!(definition instanceof PaymentDefinition.IrregularPaymentDefinition) || onlyRegular) continue;
            this.updatePayments(paymentsByFrequency, definition.getAmount(), "other");
        }
    }

    private void updatePayments(Map<String, BigDecimal> paymentsByFrequency, BigDecimal amount, String frequency) {
        BigDecimal current = paymentsByFrequency.get(frequency);
        current = current == null ? BigDecimal.ZERO : current;
        paymentsByFrequency.put(frequency, SimulationMathematicalFunctions.sum(current, amount));
    }

    private void applyIndexation(InvestPolicyValueSimulationContext.SuspenseAccount account, String source, BigDecimal ratio, int processedMonth) {
        for (PaymentDefinition definition : account.getPaymentDefinitions()) {
            if (!this.isToChange(definition, source, processedMonth)) continue;
            definition.setAmount(SimulationMathematicalFunctions.multiply(definition.getAmount(), ratio));
        }
    }

    private boolean isToChange(PaymentDefinition definition, String source, int processedMonth) {
        if (source != null && !source.equals(definition.getPaymentSource())) {
            return false;
        }
        if (definition instanceof PaymentDefinition.RegularPaymentDefinition) {
            return true;
        }
        if (definition instanceof PaymentDefinition.IrregularPaymentDefinition) {
            return ((PaymentDefinition.IrregularPaymentDefinition)definition).getMonthNumber() >= processedMonth;
        }
        return false;
    }

    private void payIntoAccount(int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, BigDecimal ... paymentAmount) {
        if (processedMonth < account.getAccountDefinition().getStartingMonth()) {
            return;
        }
        for (PaymentDefinition definition : account.getPaymentDefinitions()) {
            if (definition instanceof PaymentDefinition.RegularPaymentDefinition) {
                this.payRegularPayment(processedMonth, account, (PaymentDefinition.RegularPaymentDefinition)definition, paymentAmount);
                continue;
            }
            if (!(definition instanceof PaymentDefinition.IrregularPaymentDefinition)) continue;
            this.payIrregularPayment(processedMonth, account, (PaymentDefinition.IrregularPaymentDefinition)definition, paymentAmount);
        }
    }

    private void payRegularPayment(int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, PaymentDefinition.RegularPaymentDefinition paymentDefinition, BigDecimal ... paymentAmount) {
        Frequency paymentFrequency = paymentDefinition.getFrequency();
        if (this.isPaymentMonth(processedMonth, paymentFrequency)) {
            this.payPaymentIntoAccount(processedMonth, account, paymentDefinition, paymentAmount);
        }
    }

    private boolean isPaymentMonth(int processedMonth, Frequency paymentFrequency) {
        boolean firstMonthAndSinglePayment = processedMonth == 0 && paymentFrequency == Frequency.XP_0;
        boolean paymentMonth = paymentFrequency != Frequency.XP_0 && processedMonth % paymentFrequency.getPaymentsPeriodInMonths() == 0;
        return firstMonthAndSinglePayment || paymentMonth;
    }

    private void payIrregularPayment(int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, PaymentDefinition.IrregularPaymentDefinition paymentDefinition, BigDecimal ... paymentAmount) {
        if (this.isPaymentMonth(processedMonth, paymentDefinition.getMonthNumber())) {
            this.payPaymentIntoAccount(processedMonth, account, paymentDefinition, paymentAmount);
        }
    }

    private boolean isPaymentMonth(int processedMonth, int paymentMonth) {
        return processedMonth == paymentMonth;
    }

    private void payPaymentIntoAccount(int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, PaymentDefinition payment, BigDecimal ... paymentAmountPar) {
        BigDecimal paymentAmount = paymentAmountPar.length > 0 ? paymentAmountPar[0] : payment.getAmount();
        this.setPayment(processedMonth, account, payment.getPaymentSource(), paymentAmount);
    }

    protected void setPayment(int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, String source, BigDecimal paymentAmount) {
        if (processedMonth < account.getAccountDefinition().getStartingMonth()) {
            return;
        }
        this.payPaymentIntoProperSource(account, source, paymentAmount);
        account.saveAmountToInvestPerSource(processedMonth, source, paymentAmount);
        account.setMonthlyPaidInAmount(SimulationMathematicalFunctions.sum(account.getMonthlyPaidInAmount(), paymentAmount));
        account.setTotalPaidInAmount(SimulationMathematicalFunctions.sum(account.getTotalPaidInAmount(), paymentAmount));
        if (processedMonth <= 11) {
            account.setFirstYearPaidInAmount(SimulationMathematicalFunctions.sum(account.getFirstYearPaidInAmount(), paymentAmount));
        }
    }

    private void payPaymentIntoProperSource(InvestPolicyValueSimulationContext.SuspenseAccount account, String source, BigDecimal amount) {
        Map<String, BigDecimal> assets = account.getAmountToInvestPerSource();
        BigDecimal current = assets.get(source);
        current = current == null ? BigDecimal.ZERO : current;
        assets.put(source, SimulationMathematicalFunctions.sum(current, amount));
    }

    private void resetAccountPaymentsData(InvestPolicyValueSimulationContext.SuspenseAccount account) {
        account.setMonthlyPaidInAmount(BigDecimal.ZERO);
        for (Map.Entry<String, BigDecimal> asset : account.getAmountToInvestPerSource().entrySet()) {
            asset.setValue(BigDecimal.ZERO);
        }
    }
}

