/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.life.invest.FundDataRepository;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLife;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.mp.simulation.life.invest.api.TransferStatus;
import pl.decerto.hyperon.mp.simulation.life.invest.params.FundDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.params.SimulationVariant;
import pl.decerto.hyperon.runtime.core.HyperonEngine;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.utils.Messages;

public class Funds {
    private static final Logger log = LoggerFactory.getLogger(Funds.class);
    private FundDataRepository fundDataRepository;

    public void setAmountToInvest(SimulationLifeContext context) {
        SimulationLife simulationData = context.getSimulationData();
        this.fundDataRepository = new FundDataRepository();
        this.fundDataRepository.setup(SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId()));
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            this.startMonthForAccount(account, simulationData.getFundsParam());
        }
    }

    public void setAnnualRateReturnA2(SimulationLifeContext context) {
        SimulationLife simulationData = context.getSimulationData();
        this.fundDataRepository = new FundDataRepository();
        this.fundDataRepository.setup(SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId()));
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            this.setAnnualRateReturnA2(account, simulationData.getPeriodNumber(), simulationData.getSimulationVariant());
        }
    }

    public void setAnnualRateReturn(SimulationLifeContext context, String parameterName, boolean sqrt) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            this.setAnnualRateReturn(account, parameterName, context, simulationData.getPeriodNumber(), sqrt);
        }
    }

    public void buyUnits(SimulationLifeContext context, String ... accountCode) {
        SimulationLife simulationData = context.getSimulationData();
        List<String> accounts = accountCode.length == 0 ? null : Arrays.asList(accountCode);
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (accounts != null && !accounts.contains(account.getCode())) continue;
            this.buyUnitsForAccount(account, simulationData.getPeriodNumber());
        }
    }

    public void updateFundPrices(SimulationLifeContext context, boolean endMonth) {
        SimulationLife simulationData = context.getSimulationData();
        this.recalculatePrices(simulationData.getAccounts(), endMonth ? simulationData.getPeriodNumber() : simulationData.getPeriodNumber() - 1);
    }

    public void setMonthlyEffectiveRateReturn(SimulationLifeContext context, String accountCode, String fundCode, BigDecimal value) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (!account.getCode().equals(accountCode)) continue;
            InvestPolicyValueSimulationContext.Fund fund = account.getFund(fundCode);
            if (fund != null) {
                fund.setMonthlyEffectiveRateReturn(value);
            }
            return;
        }
    }

    public BigDecimal getUnitsAtBeginning(SimulationLifeContext context, String accountCode, String fundCode) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (!account.getCode().equals(accountCode)) continue;
            InvestPolicyValueSimulationContext.Fund fund = account.getFund(fundCode);
            if (fund == null) break;
            return fund.getUnitsAtBegining();
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getUnitsPrice(SimulationLifeContext context, String accountCode, String fundCode) {
        SimulationLife simulationData = context.getSimulationData();
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (!account.getCode().equals(accountCode)) continue;
            InvestPolicyValueSimulationContext.Fund fund = account.getFund(fundCode);
            if (fund == null) break;
            return fund.getUnitPrice();
        }
        return BigDecimal.ZERO;
    }

    public TransferStatus transfer(SimulationLifeContext context, String accountFrom, String fundFrom, String accountTo, String fundTo, BigDecimal amount) {
        SimulationLife simulationData = context.getSimulationData();
        TransferData data = new TransferData(accountFrom, accountTo, fundFrom, fundTo, null);
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (account.getCode().equals(accountFrom)) {
                data.setAccountFromData(account);
            }
            if (account.getCode().equals(accountTo)) {
                data.setAccountToData(account);
            }
            if (!data.accountsSelected()) continue;
            break;
        }
        try {
            data.checkIfAccountsOK(amount);
            data.transfer(amount);
        }
        catch (HyperonRuntimeException e) {
            log.error("", (Throwable)e);
            return new TransferStatus(false, e.getMessage());
        }
        return new TransferStatus(true, Messages.message("simulation.transfer.ok", amount, accountFrom + "/" + fundFrom, accountTo + "/" + fundTo));
    }

    public TransferStatus transfer(SimulationLifeContext context, String accountFrom, String accountTo, BigDecimal amount, FundsSplitType splitType) {
        SimulationLife simulationData = context.getSimulationData();
        TransferData data = new TransferData(accountFrom, accountTo, null, null, splitType);
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationData.getAccounts()) {
            if (account.getCode().equals(accountFrom)) {
                data.setAccountFromData(account);
            }
            if (account.getCode().equals(accountTo)) {
                data.setAccountToData(account);
            }
            if (!data.accountsSelected()) continue;
            break;
        }
        try {
            data.checkIfAccountsOK(amount);
            data.transferPropotional(amount);
        }
        catch (HyperonRuntimeException e) {
            log.error("", (Throwable)e);
            return new TransferStatus(false, e.getMessage());
        }
        return new TransferStatus(true, Messages.message("simulation.transfer.ok", amount, accountFrom, accountTo));
    }

    private void startMonthForAccount(InvestPolicyValueSimulationContext.SuspenseAccount account, String fundParam) {
        this.calculateAmountToInvest(account);
        List<FundDefinition> fundDefinitions = account.getFundDefinitions();
        for (FundDefinition fundDefinition : fundDefinitions) {
            this.startMonthForFund(account, fundDefinition, fundParam);
        }
    }

    private void calculateAmountToInvest(InvestPolicyValueSimulationContext.SuspenseAccount account) {
        BigDecimal amount = BigDecimal.ZERO;
        for (Map.Entry<String, BigDecimal> e : account.getAmountToInvestPerSource().entrySet()) {
            amount = SimulationMathematicalFunctions.sum(amount, e.getValue());
        }
        account.setAmountToInvest(amount);
    }

    private InvestPolicyValueSimulationContext.Fund startMonthForFund(InvestPolicyValueSimulationContext.SuspenseAccount account, FundDefinition fundDefinition, String fundParam) {
        InvestPolicyValueSimulationContext.Fund fund = account.getFund(fundDefinition.getCode());
        if (fund == null) {
            fund = this.createFund(account, fundDefinition, fundParam);
        }
        BigDecimal accountAmountToInvest = account.getAmountToInvest();
        fund.setAmountToInvest(SimulationMathematicalFunctions.multiply(accountAmountToInvest, fundDefinition.getSplit()));
        return fund;
    }

    private InvestPolicyValueSimulationContext.Fund createFund(InvestPolicyValueSimulationContext.SuspenseAccount account, FundDefinition fundDefinition, String fundParam) {
        InvestPolicyValueSimulationContext.Fund fund = new InvestPolicyValueSimulationContext.Fund(fundDefinition);
        account.addFund(fund);
        if (StringUtils.isBlank((CharSequence)fund.getName())) {
            String name = this.fundDataRepository.getInvestmentItemName(fundParam, fund.getCode(), fund.getFundDefinition().getType());
            fund.setName(name);
        }
        return fund;
    }

    private BigDecimal getAnnualRateReturnA2(FundDefinition fund, SimulationVariant variant, int monthNo) {
        return this.fundDataRepository.getAnnualRateReturn(fund.getType(), fund.getCode(), monthNo, variant.name());
    }

    private void recalculatePrices(List<InvestPolicyValueSimulationContext.SuspenseAccount> accounts, int processedMonth) {
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : accounts) {
            List<FundDefinition> fundDefinitions = account.getFundDefinitions();
            for (FundDefinition fundDefinition : fundDefinitions) {
                this.recalculateFund(processedMonth, account, fundDefinition);
            }
        }
    }

    private InvestPolicyValueSimulationContext.Fund recalculateFund(int processedMonth, InvestPolicyValueSimulationContext.SuspenseAccount account, FundDefinition fundDefinition) {
        InvestPolicyValueSimulationContext.Fund fund = account.getFund(fundDefinition.getCode());
        fund.setUnitPrice(this.getEndMonthUnitPrice(processedMonth, fund));
        fund.setCapital(SimulationMathematicalFunctions.multiply(fund.getUnitPrice(), fund.getUnits()));
        return fund;
    }

    private BigDecimal getEndMonthUnitPrice(int monthNo, InvestPolicyValueSimulationContext.Fund fund) {
        return SimulationMathematicalFunctions.calculateMonthUnitPrice(monthNo + 1, fund.getMonthlyEffectiveRateReturn());
    }

    private void setAnnualRateReturnA2(InvestPolicyValueSimulationContext.SuspenseAccount account, int processedMonth, SimulationVariant simulationVariant) {
        if (SimulationMathematicalFunctions.isFirstMonthOfYear(processedMonth)) {
            for (InvestPolicyValueSimulationContext.Fund fund : account.getFunds()) {
                fund.setAnnualRateReturn(this.getAnnualRateReturnA2(fund.getFundDefinition(), simulationVariant, processedMonth));
            }
        }
    }

    private void setAnnualRateReturn(InvestPolicyValueSimulationContext.SuspenseAccount account, String parameterName, SimulationLifeContext context, int processedMonth, boolean sqrt) {
        if (SimulationMathematicalFunctions.isFirstMonthOfYear(processedMonth)) {
            for (InvestPolicyValueSimulationContext.Fund fund : account.getFunds()) {
                context.setCurrentFund(fund);
                fund.setAnnualRateReturn(this.geAnnualRateValue(parameterName, context));
                if (sqrt) {
                    this.calculateRateReturnForFirstMonthOfYearSqrt(processedMonth, fund);
                    continue;
                }
                this.calculateRateReturnForFirstMonthOfYear(fund);
            }
        }
    }

    private BigDecimal geAnnualRateValue(String parameterName, SimulationLifeContext context) {
        HyperonEngine engine = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
        try {
            ParamValue pv = engine.get(parameterName, context);
            return pv == null || pv.size() == 0 ? BigDecimal.ZERO : pv.getBigDecimal("rate");
        }
        catch (ParameterValueNotFoundException e) {
            log.error("", (Throwable)e);
            return BigDecimal.ZERO;
        }
    }

    private void buyUnitsForAccount(InvestPolicyValueSimulationContext.SuspenseAccount account, int processedMonth) {
        for (InvestPolicyValueSimulationContext.Fund fund : account.getFunds()) {
            if (this.isFirstMonthNotSetUnitPrice(processedMonth, fund.getUnitPrice())) {
                fund.setUnitPrice(BigDecimal.valueOf(1.0));
            }
            fund.setUnitPriceAtBegining(fund.getUnitPrice());
            fund.setBoughtUnits(SimulationMathematicalFunctions.divide(fund.getAmountToInvest(), fund.getUnitPrice()));
            fund.setUnits(SimulationMathematicalFunctions.sum(fund.getUnits(), fund.getBoughtUnits()));
            fund.setUnitsAtBegining(fund.getUnits());
            fund.setCapital(SimulationMathematicalFunctions.multiply(fund.getUnitPrice(), fund.getUnits()));
            fund.setCapitalAtBegining(fund.getCapital());
        }
    }

    private boolean isFirstMonthNotSetUnitPrice(int processedMonth, BigDecimal unitPrice) {
        return processedMonth == 0 && (unitPrice == null || unitPrice.equals(BigDecimal.ZERO));
    }

    private void calculateRateReturnForFirstMonthOfYearSqrt(int processedMonth, InvestPolicyValueSimulationContext.Fund fund) {
        BigDecimal monthlyEffectiveRateReturn = SimulationMathematicalFunctions.calculateMonthEffectiveRateReturn(fund.getAnnualRateReturn());
        fund.setUnitPrice(SimulationMathematicalFunctions.calculateMonthUnitPrice(processedMonth, monthlyEffectiveRateReturn));
        fund.setMonthlyEffectiveRateReturn(monthlyEffectiveRateReturn);
    }

    private void calculateRateReturnForFirstMonthOfYear(InvestPolicyValueSimulationContext.Fund fund) {
        BigDecimal monthlyEffectiveRateReturn = SimulationMathematicalFunctions.divide(fund.getAnnualRateReturn(), new BigDecimal(12));
        fund.setMonthlyEffectiveRateReturn(monthlyEffectiveRateReturn);
    }

    class TransferData {
        private final String accountFrom;
        private final String accountTo;
        private final String fundFrom;
        private final String fundTo;
        private final FundsSplitType splitType;
        private InvestPolicyValueSimulationContext.SuspenseAccount accountFromData = null;
        private InvestPolicyValueSimulationContext.SuspenseAccount accountToData = null;

        TransferData(String accountFrom, String accountTo, String fundFrom, String fundTo, FundsSplitType splitType) {
            this.accountFrom = accountFrom;
            this.accountTo = accountTo;
            this.fundFrom = fundFrom;
            this.fundTo = fundTo;
            this.splitType = splitType;
        }

        public void transfer(BigDecimal amount) {
            InvestPolicyValueSimulationContext.Fund fundData = this.accountFromData.getFund(this.fundFrom);
            this.transferForFund(amount, fundData, true);
            fundData = this.accountToData.getFund(this.fundTo);
            if (fundData.getUnitPrice() == null) {
                fundData.setUnitPrice(new BigDecimal(1));
            }
            this.transferForFund(amount, fundData, false);
        }

        public void transferPropotional(BigDecimal amount) {
            for (InvestPolicyValueSimulationContext.Fund fundData : this.accountFromData.getFunds()) {
                BigDecimal percent;
                BigDecimal allAmount = null;
                if (amount == null) {
                    allAmount = SimulationMathematicalFunctions.multiply(fundData.getUnits(), fundData.getUnitPrice());
                    fundData.transferUnits(fundData.getUnits().negate());
                    fundData.setCapital(new BigDecimal("0"));
                } else {
                    percent = SimulationMathematicalFunctions.multiply(amount, this.getPercent(fundData, this.accountFromData));
                    this.transferForFund(percent, fundData, true);
                }
                InvestPolicyValueSimulationContext.Fund fundTo = this.accountToData.getFund(fundData.getCode());
                if (fundData.getUnitPrice() == null) {
                    fundData.setUnitPrice(new BigDecimal(1));
                }
                percent = amount == null ? allAmount : SimulationMathematicalFunctions.multiply(amount, this.getPercent(fundTo, this.accountToData));
                this.transferForFund(percent, fundTo, false);
            }
        }

        private BigDecimal getPercent(InvestPolicyValueSimulationContext.Fund fundData, InvestPolicyValueSimulationContext.SuspenseAccount accountData) {
            if (this.splitType == FundsSplitType.ACCOUNT_DEFINITION_SPLIT) {
                return fundData.getFundDefinition().getSplit();
            }
            BigDecimal totalUnits = accountData.getTotalUnits();
            if (SimulationMathematicalFunctions.greaterThanZero(totalUnits)) {
                return SimulationMathematicalFunctions.divide(fundData.getUnits(), totalUnits);
            }
            return BigDecimal.ZERO;
        }

        private void transferForFund(BigDecimal amount, InvestPolicyValueSimulationContext.Fund fundData, boolean negate) {
            BigDecimal unitsToTransfer = SimulationMathematicalFunctions.divide(amount, fundData.getUnitPrice());
            if (negate) {
                fundData.transferUnits(unitsToTransfer.negate());
            } else {
                fundData.transferUnits(unitsToTransfer);
            }
            fundData.setCapital(SimulationMathematicalFunctions.multiply(fundData.getUnitPrice(), fundData.getUnits()));
        }

        public void checkIfAccountsOK(BigDecimal amount) throws HyperonRuntimeException {
            StringBuilder message = null;
            boolean err = false;
            if (this.accountFromData == null) {
                message = new StringBuilder(Messages.message("simulation.transfer.noAccount", this.accountFrom));
                err = true;
            }
            if (this.accountToData == null) {
                message = this.appendMessage(message, Messages.message("simulation.transfer.noAccount", this.accountTo));
                err = true;
            }
            if (err) {
                throw new HyperonRuntimeException(message.toString());
            }
            if (this.fundFrom != null) {
                this.checkFunds(amount, message, err);
            } else {
                this.compareFundsDefinitions(this.accountFromData, this.accountToData, amount);
            }
        }

        private void checkFunds(BigDecimal amount, StringBuilder message, boolean err) {
            if (this.accountFromData.getFund(this.fundFrom) == null) {
                this.appendMessage(message, Messages.message("simulation.transfer.noFund", this.fundFrom, this.accountFrom));
                err = true;
            }
            if (this.accountToData.getFund(this.fundTo) == null) {
                this.appendMessage(message, Messages.message("simulation.transfer.noFund", this.fundTo, this.accountTo));
                err = true;
            }
            if (err) {
                throw new HyperonRuntimeException(Objects.isNull(message) ? null : message.toString());
            }
            InvestPolicyValueSimulationContext.Fund fund = this.accountFromData.getFund(this.fundFrom);
            if (fund.getCapital().compareTo(amount) < 0) {
                throw new HyperonRuntimeException(Messages.message("simulation.transfer.noFundValue", this.fundFrom));
            }
        }

        private void compareFundsDefinitions(InvestPolicyValueSimulationContext.SuspenseAccount accountFromData, InvestPolicyValueSimulationContext.SuspenseAccount accountToData, BigDecimal amount) throws HyperonRuntimeException {
            StringBuilder message = new StringBuilder();
            ArrayList<String> checkFunds = new ArrayList<String>();
            for (InvestPolicyValueSimulationContext.Fund fund : accountFromData.getFunds()) {
                InvestPolicyValueSimulationContext.Fund fundTo = accountToData.getFund(fund.getCode());
                if (fundTo == null) {
                    checkFunds.add(fund.getCode());
                    this.appendMessage(message, Messages.message("simulation.transfer.noFund", fund.getCode(), accountToData.getCode()));
                } else if (fundTo.getFundDefinition().getSplit().compareTo(fund.getFundDefinition().getSplit()) != 0) {
                    this.appendMessage(message, Messages.message("simulation.transfer.differentSplit", fund.getCode()));
                }
                if (this.splitType == FundsSplitType.ALL_UNITS || fund.getCapital().compareTo(SimulationMathematicalFunctions.multiply(amount, this.getPercent(fund, accountFromData))) >= 0) continue;
                this.appendMessage(message, Messages.message("simulation.transfer.noFundValue", fund.getCode()));
            }
            for (InvestPolicyValueSimulationContext.Fund fund : accountToData.getFunds()) {
                if (checkFunds.contains(fund.getCode()) || accountFromData.getFund(fund.getCode()) != null) continue;
                this.appendMessage(message, Messages.message("simulation.transfer.noFund", fund.getCode(), accountFromData.getCode()));
            }
            if (message.length() != 0) {
                throw new HyperonRuntimeException(message.toString());
            }
        }

        private StringBuilder appendMessage(StringBuilder message, String msg) {
            if (message == null) {
                message = new StringBuilder(msg);
            } else {
                message.append("\n");
                message.append(msg);
            }
            return message;
        }

        public boolean accountsSelected() {
            return this.accountFromData != null && this.accountToData != null;
        }

        public void setAccountFromData(InvestPolicyValueSimulationContext.SuspenseAccount accountFromData) {
            this.accountFromData = accountFromData;
        }

        public void setAccountToData(InvestPolicyValueSimulationContext.SuspenseAccount accountToData) {
            this.accountToData = accountToData;
        }
    }

    public static enum FundsSplitType {
        ACCOUNT_DEFINITION_SPLIT,
        ACCOUNT_BALANCE_SPLIT,
        ALL_UNITS;

    }
}

