/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest.api;

import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class ChargeDefinition {
    private static final Logger log = LoggerFactory.getLogger(ChargeDefinition.class);
    private String code;
    private String name;
    private String functionName;
    private String chargeValueParameter;

    public ChargeDefinition(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public ChargeDefinition(String code, String name, String functionName, String chargeValueParameter) {
        this(code, name);
        this.functionName = functionName;
        this.chargeValueParameter = chargeValueParameter;
    }

    public static List<ChargeDefinition> findCollectors(String parameterName, SimulationLifeContext context) {
        ArrayList<ChargeDefinition> result = new ArrayList<ChargeDefinition>();
        HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
        try {
            ParamValue pv = mpEngine.get(parameterName, context);
            if (pv != null) {
                for (int i = 0; i < pv.size(); ++i) {
                    result.add(new ChargeDefinition((String)pv.get(i, "charge.code"), (String)pv.get(i, "charge.name"), (String)pv.get(i, "charge.collector"), (String)pv.get(i, "charge.value.parameter")));
                }
            }
        }
        catch (ParameterValueNotFoundException e) {
            log.error("No charge definitions [" + parameterName + "] ", (Throwable)e);
        }
        return result;
    }

    public String getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public String getChargeValueParameter() {
        return this.chargeValueParameter;
    }
}

