/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import pl.decerto.hyperon.mp.simulation.SimulationMathematicalFunctions;
import pl.decerto.hyperon.mp.simulation.event.SimulationEvent;
import pl.decerto.hyperon.mp.simulation.event.SimulationListener;
import pl.decerto.hyperon.mp.simulation.life.invest.InvestPolicyValueSimulationContext;
import pl.decerto.hyperon.mp.simulation.life.invest.charge.CollectedCharge;
import pl.decerto.hyperon.mp.simulation.life.invest.event.InvestPolicyValueSimulationEvent;
import pl.decerto.hyperon.mp.simulation.life.invest.params.FundDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.result.year.AnnualResult;
import pl.decerto.hyperon.mp.simulation.life.invest.result.year.InvestmentItemProfitability;
import pl.decerto.hyperon.mp.simulation.life.invest.result.year.InvestmentItemType;
import pl.decerto.hyperon.mp.simulation.life.invest.result.year.SimulationResult;
import pl.decerto.hyperon.mp.simulation.life.invest.result.year.SuspenseAccountResult;

public class YearResultBuilder
implements SimulationListener {
    private SimulationResult result;
    private AnnualResult currentAnnualResult;
    private SuspenseAccountResult currentAccountResult;
    private Set<String> annualProcessedFundCodes;
    private Map<String, BigDecimal> feesPerAccount;
    private Map<String, BigDecimal> feesPerCharge = new HashMap<String, BigDecimal>();

    @Override
    public void onEvent(SimulationEvent e) {
        InvestPolicyValueSimulationEvent event = (InvestPolicyValueSimulationEvent)e;
        String operationName = event.getEventName();
        if ("SIMULATION_STARTED".equals(operationName)) {
            this.afterSimulationStarted(event);
        } else if ("SAMPLE_PROCESSED".equals(operationName)) {
            this.afterSampleProcessed(event);
        } else if ("SIMULATION_FINISHED".equals(operationName)) {
            this.afterSimulationFinished(event);
        }
    }

    private void afterSimulationFinished(InvestPolicyValueSimulationEvent event) {
        InvestPolicyValueSimulationContext simulationContext = event.getSimulationContext();
        this.result.addMissingPath(simulationContext.getMissingPaths());
        this.result.setMissingRequiredParams(simulationContext.getMissingRequiredParams());
    }

    public void afterSimulationStarted(InvestPolicyValueSimulationEvent event) {
        this.result = new SimulationResult();
        this.annualProcessedFundCodes = new HashSet<String>();
        this.feesPerAccount = new HashMap<String, BigDecimal>();
    }

    public void afterSampleProcessed(InvestPolicyValueSimulationEvent event) {
        InvestPolicyValueSimulationContext simulationContext = event.getSimulationContext();
        this.aggregateChargeResults(simulationContext);
        if (SimulationMathematicalFunctions.isLastMonthOfYear(simulationContext.getProcessedMonth())) {
            this.afterAnnualSampleProcessed(event);
        }
    }

    public void afterAnnualSampleProcessed(InvestPolicyValueSimulationEvent event) {
        InvestPolicyValueSimulationContext simulationContext = event.getSimulationContext();
        int yearNumber = SimulationMathematicalFunctions.calculateYearNumber(simulationContext.getProcessedMonth());
        this.currentAnnualResult = new AnnualResult();
        this.currentAnnualResult.setYearNumber(yearNumber);
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationContext.getAccounts()) {
            this.prepareAccountResult(account);
        }
        this.currentAnnualResult.setTotalFeesPerChargeCode(this.feesPerCharge);
        this.result.addAnnualResult(this.currentAnnualResult);
        this.result.addMissingPath(simulationContext.getMissingPaths());
        this.currentAnnualResult = null;
        this.annualProcessedFundCodes.clear();
        this.feesPerAccount.clear();
        this.feesPerCharge.clear();
    }

    private void prepareAccountResult(InvestPolicyValueSimulationContext.SuspenseAccount account) {
        this.currentAccountResult = new SuspenseAccountResult();
        this.currentAccountResult.setAccountType(account.getCode());
        this.currentAccountResult.setTotalPaidInPremiumAmount(account.getTotalPaidInAmount());
        this.currentAccountResult.setTotalCapital(account.getCapital());
        this.currentAccountResult.setSurrenderCapital(account.getSurrenderValue());
        this.currentAccountResult.setSurrenderFee(account.getSurrenderCharge());
        BigDecimal fees = this.getFeesForAccountOrZero(account);
        this.currentAccountResult.setTotalFees(fees);
        for (InvestPolicyValueSimulationContext.Fund fund : account.getFunds()) {
            this.prepareFundResult(fund);
        }
        this.currentAnnualResult.setTotalPaidInPremiumAmount(SimulationMathematicalFunctions.sum(this.currentAnnualResult.getTotalPaidInPremiumAmount(), account.getTotalPaidInAmount()));
        this.currentAnnualResult.setTotalCapital(SimulationMathematicalFunctions.sum(this.currentAnnualResult.getTotalCapital(), this.currentAccountResult.getTotalCapital()));
        this.currentAnnualResult.setTotalFees(SimulationMathematicalFunctions.sum(this.currentAnnualResult.getTotalFees(), fees));
        this.currentAnnualResult.setSurrenderCapital(SimulationMathematicalFunctions.sum(account.getSurrenderValue(), this.currentAnnualResult.getSurrenderCapital()));
        this.currentAnnualResult.setSurrenderFee(SimulationMathematicalFunctions.sum(account.getSurrenderCharge(), this.currentAnnualResult.getSurrenderFee()));
        this.currentAnnualResult.addSuspenseAccountResult(this.currentAccountResult);
        this.currentAccountResult = null;
    }

    private void prepareFundResult(InvestPolicyValueSimulationContext.Fund fund) {
        if (!this.annualProcessedFundCodes.contains(fund.getCode())) {
            this.annualProcessedFundCodes.add(fund.getCode());
            FundDefinition definition = fund.getFundDefinition();
            InvestmentItemProfitability itemProfitability = new InvestmentItemProfitability();
            itemProfitability.setCode(fund.getCode());
            itemProfitability.setType(InvestmentItemType.valueOf(definition.getType()));
            itemProfitability.setName(fund.getName());
            itemProfitability.setRateReturn(fund.getAnnualRateReturn());
            this.currentAnnualResult.addInvestmentItemProfitability(itemProfitability);
        }
    }

    private void aggregateChargeResults(InvestPolicyValueSimulationContext simulationContext) {
        for (InvestPolicyValueSimulationContext.SuspenseAccount account : simulationContext.getAccounts()) {
            BigDecimal fees = this.getFeesForAccountOrZero(account);
            for (CollectedCharge charge : account.getCollectedCharges()) {
                fees = SimulationMathematicalFunctions.sum(fees, charge.getChargedAmount());
                this.sumFeePerChargeCode(charge);
            }
            this.feesPerAccount.put(account.getCode(), fees);
        }
    }

    private void sumFeePerChargeCode(CollectedCharge charge) {
        BigDecimal totalFeeByCharge = this.feesPerCharge.get(charge.getCode());
        if (totalFeeByCharge == null) {
            totalFeeByCharge = new BigDecimal("0");
        }
        this.feesPerCharge.put(charge.getCode(), SimulationMathematicalFunctions.sum(totalFeeByCharge, charge.getChargedAmount()));
    }

    public SimulationResult getSimulationResult() {
        return this.result;
    }

    private BigDecimal getFeesForAccountOrZero(InvestPolicyValueSimulationContext.SuspenseAccount account) {
        BigDecimal fees = this.feesPerAccount.get(account.getCode());
        return fees == null ? BigDecimal.ZERO : fees;
    }
}

