/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation.life.invest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.context.DefaultContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.mp.simulation.life.invest.HyperonNoAlgorithmDefinition;
import pl.decerto.hyperon.mp.simulation.life.invest.SimulationMpEngineProvider;
import pl.decerto.hyperon.mp.simulation.life.invest.api.SimulationLifeContext;
import pl.decerto.hyperon.runtime.core.HyperonEngine;

public class AlgorithmProvider {
    private static final Logger log = LoggerFactory.getLogger(AlgorithmProvider.class);
    private static final String ORDER_COL = "stepOrder";
    private static final String STEP_NAME_COL = "stepName";
    private static final String STEP_FUNCTION_COL = "stepFunction";
    private static final String STEP_CHARGE_PHASE = "stepChargePhase";

    public List<AlgorithmStep> findAlgorithm(String parameterName, String simulationId) {
        return this.findSteps(parameterName, simulationId);
    }

    private List<AlgorithmStep> findSteps(String parameterName, String simulationId) {
        HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(simulationId);
        try {
            ParamValue pv = mpEngine.get(parameterName, new DefaultContext());
            if (pv != null && pv.size() > 0) {
                return this.extractStepsInProperOrder(pv);
            }
            throw new HyperonNoAlgorithmDefinition(String.format("No parameter %s with algorithm definition", parameterName));
        }
        catch (ParameterValueNotFoundException e) {
            log.error("", (Throwable)e);
            throw new HyperonNoAlgorithmDefinition(String.format("No parameter %s with algorithm definition", parameterName));
        }
    }

    private List<AlgorithmStep> extractStepsInProperOrder(ParamValue pv) {
        ArrayList<AlgorithmStep> steps = new ArrayList<AlgorithmStep>();
        for (int i = 0; i < pv.size(); ++i) {
            steps.add(new AlgorithmStep(pv.get(i, ORDER_COL, Long.class).intValue(), pv.get(i, STEP_NAME_COL, String.class), pv.get(i, STEP_FUNCTION_COL, String.class), pv.get(i, STEP_CHARGE_PHASE, String.class)));
        }
        Collections.sort(steps);
        return steps;
    }

    public final class AlgorithmStep
    implements Comparable<AlgorithmStep> {
        private final Integer order;
        private final String stepName;
        private final String stepFunction;
        private final String chargePhase;

        public void executeStep(SimulationLifeContext context) {
            this.executeRhinoStep(context, this.stepFunction);
        }

        @Override
        public int compareTo(AlgorithmStep o) {
            return this.order.compareTo(o.order);
        }

        private void executeRhinoStep(SimulationLifeContext context, String functionName) {
            if (StringUtils.isBlank((CharSequence)functionName)) {
                return;
            }
            HyperonEngine mpEngine = SimulationMpEngineProvider.getEngineForSimulation(context.getSimulationId());
            context.setCurrentPhase(this.chargePhase == null ? "" : this.chargePhase);
            try {
                mpEngine.call(functionName, context, new Object[0]);
            }
            catch (Exception e) {
                log.error("function name " + functionName, (Throwable)e);
                throw e;
            }
        }

        public AlgorithmStep(Integer order, String stepName, String stepFunction, String chargePhase) {
            this.order = order;
            this.stepName = stepName;
            this.stepFunction = stepFunction;
            this.chargePhase = chargePhase;
        }

        public Integer getOrder() {
            return this.order;
        }

        public String getStepName() {
            return this.stepName;
        }

        public String getStepFunction() {
            return this.stepFunction;
        }

        public String getChargePhase() {
            return this.chargePhase;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof AlgorithmStep)) {
                return false;
            }
            AlgorithmStep other = (AlgorithmStep)o;
            Integer this$order = this.getOrder();
            Integer other$order = other.getOrder();
            if (this$order == null ? other$order != null : !((Object)this$order).equals(other$order)) {
                return false;
            }
            String this$stepName = this.getStepName();
            String other$stepName = other.getStepName();
            if (this$stepName == null ? other$stepName != null : !this$stepName.equals(other$stepName)) {
                return false;
            }
            String this$stepFunction = this.getStepFunction();
            String other$stepFunction = other.getStepFunction();
            if (this$stepFunction == null ? other$stepFunction != null : !this$stepFunction.equals(other$stepFunction)) {
                return false;
            }
            String this$chargePhase = this.getChargePhase();
            String other$chargePhase = other.getChargePhase();
            return !(this$chargePhase == null ? other$chargePhase != null : !this$chargePhase.equals(other$chargePhase));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $order = this.getOrder();
            result = result * 59 + ($order == null ? 43 : ((Object)$order).hashCode());
            String $stepName = this.getStepName();
            result = result * 59 + ($stepName == null ? 43 : $stepName.hashCode());
            String $stepFunction = this.getStepFunction();
            result = result * 59 + ($stepFunction == null ? 43 : $stepFunction.hashCode());
            String $chargePhase = this.getChargePhase();
            result = result * 59 + ($chargePhase == null ? 43 : $chargePhase.hashCode());
            return result;
        }

        public String toString() {
            return "AlgorithmProvider.AlgorithmStep(order=" + this.getOrder() + ", stepName=" + this.getStepName() + ", stepFunction=" + this.getStepFunction() + ", chargePhase=" + this.getChargePhase() + ")";
        }
    }
}

