/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.mp.simulation;

import java.math.BigDecimal;

public class SimulationMathematicalFunctions {
    public static final int DEFAULT_SCALE = 10;
    public static final int DEFAULT_ROUND_MODE = 4;
    public static final int NUMBER_OF_MONTHS_IN_YEAR = 12;
    public static final int NUMBER_OF_LAST_MONTH_IN_YEAR = 11;
    public static final BigDecimal NUMBER_OF_MONTHS = BigDecimal.valueOf(12L);
    public static final BigDecimal ONE_HUNDRED = BigDecimal.valueOf(100L);
    public static final BigDecimal TWO = BigDecimal.valueOf(2L);

    private SimulationMathematicalFunctions() {
        throw new UnsupportedOperationException();
    }

    public static boolean isFirstMonthOfYear(int monthNumber) {
        return (monthNumber + 1) % 12 == 1;
    }

    public static int calculateYearNumber(int monthNumber) {
        return (monthNumber + 1) / 12;
    }

    public static boolean isLastMonthOfYear(int monthNumber) {
        return (monthNumber + 1) % 12 == 0;
    }

    public static BigDecimal calculateMonthUnitPrice(int monthNo, BigDecimal monthRateReturn) {
        return BigDecimal.valueOf(Math.pow(1.0 + monthRateReturn.doubleValue(), monthNo));
    }

    public static BigDecimal calculateMonthEffectiveRateReturn(BigDecimal yearRateReturn) {
        return BigDecimal.valueOf(Math.pow(1.0 + yearRateReturn.doubleValue(), 0.08333333333333333) - 1.0);
    }

    public static BigDecimal sum(BigDecimal val1, BigDecimal val2) {
        return SimulationMathematicalFunctions.sum(val1, val2, 10);
    }

    public static BigDecimal sum(BigDecimal val1, BigDecimal val2, int scale) {
        return SimulationMathematicalFunctions.scale(val1.add(val2), scale);
    }

    public static BigDecimal subtract(BigDecimal val1, BigDecimal val2) {
        return SimulationMathematicalFunctions.subtract(val1, val2, 10);
    }

    public static BigDecimal subtract(BigDecimal val1, BigDecimal val2, int scale) {
        return SimulationMathematicalFunctions.scale(val1.subtract(val2), scale);
    }

    public static BigDecimal multiply(BigDecimal val1, BigDecimal val2) {
        return SimulationMathematicalFunctions.multiply(val1, val2, 10);
    }

    public static BigDecimal multiply(BigDecimal val1, BigDecimal val2, int scale) {
        return SimulationMathematicalFunctions.scale(val1.multiply(val2), scale);
    }

    public static BigDecimal divide(BigDecimal val1, BigDecimal val2) {
        return SimulationMathematicalFunctions.divide(val1, val2, 10);
    }

    public static BigDecimal average(BigDecimal ... values) {
        BigDecimal result = BigDecimal.ZERO;
        for (BigDecimal value : values) {
            result = SimulationMathematicalFunctions.sum(result, value);
        }
        return SimulationMathematicalFunctions.divide(result, BigDecimal.valueOf(values.length));
    }

    public static BigDecimal divide(BigDecimal val1, BigDecimal val2, int scale) {
        return val1.divide(val2, scale, 4);
    }

    public static BigDecimal pow(BigDecimal val, int n) {
        return SimulationMathematicalFunctions.pow(val, n, 10);
    }

    public static BigDecimal pow(BigDecimal val, int n, int scale) {
        return SimulationMathematicalFunctions.scale(val.pow(n), scale);
    }

    public static boolean equals(BigDecimal val1, BigDecimal val2) {
        return val1.compareTo(val2) == 0;
    }

    public static boolean lessThan(BigDecimal val1, BigDecimal val2) {
        return val1.compareTo(val2) < 0;
    }

    public static boolean greaterThan(BigDecimal val1, BigDecimal val2) {
        return val1.compareTo(val2) > 0;
    }

    public static boolean greaterThanZero(BigDecimal val) {
        return val.compareTo(BigDecimal.ZERO) > 0;
    }

    public static BigDecimal scale(BigDecimal val, int scale) {
        return val.setScale(scale, 4);
    }

    public static BigDecimal lesser(BigDecimal val1, BigDecimal val2) {
        return SimulationMathematicalFunctions.lessThan(val1, val2) ? val1 : val2;
    }
}

