/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.types.datetime;

import java.util.Calendar;
import java.util.Date;
import org.smartparam.engine.annotated.annotations.ParamType;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.types.datetime.DatetimeHolder;
import org.smartparam.engine.util.EngineUtil;
import pl.decerto.hyperon.runtime.utils.HprDate;

@ParamType(value="datetime")
public class DatetimeType
implements Type<DatetimeHolder> {
    private static String defaultOutputPattern = "yyyy-MM-dd HH:mm:ss.SSS";

    @Override
    public String encode(DatetimeHolder holder) {
        return holder.getString(defaultOutputPattern);
    }

    @Override
    public DatetimeHolder decode(String text) {
        Date date = EngineUtil.hasText(text) ? this.guess(text) : null;
        return new DatetimeHolder(date);
    }

    @Override
    public DatetimeHolder convert(Object obj) {
        if (obj instanceof Date) {
            return new DatetimeHolder((Date)obj);
        }
        if (obj instanceof Calendar) {
            Calendar cal = (Calendar)obj;
            return new DatetimeHolder(cal.getTime());
        }
        if (obj == null) {
            return new DatetimeHolder(null);
        }
        if (obj instanceof String) {
            return this.decode((String)obj);
        }
        throw new IllegalArgumentException("conversion not supported for: " + obj.getClass());
    }

    public DatetimeHolder[] newArray(int size) {
        return new DatetimeHolder[size];
    }

    private Date guess(String text) {
        String input = text.trim();
        if (this.isDigitsOnly(input)) {
            return new Date(Long.parseLong(input));
        }
        String dateText = input;
        String timeText = "";
        for (int i = 0; i < input.length(); ++i) {
            char c = input.charAt(i);
            if (!Character.isWhitespace(c)) continue;
            dateText = input.substring(0, i).trim();
            timeText = input.substring(i, input.length()).trim();
            break;
        }
        Date date = HprDate.guess(dateText);
        int time = HprDate.parseTime(timeText);
        return new Date(date.getTime() + (long)time);
    }

    private boolean isDigitsOnly(String text) {
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (Character.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    public static String getDefaultOutputPattern() {
        return defaultOutputPattern;
    }
}

