/*
 * Decompiled with CFR 0.152.
 */
package org.smartparam.engine.core;

import java.util.Arrays;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.InvalidFunctionToCallException;
import org.smartparam.engine.core.InvalidLevelValuesQuery;
import org.smartparam.engine.core.ParamEngine;
import org.smartparam.engine.core.ParamEngineRuntimeConfig;
import org.smartparam.engine.core.ParamEngineRuntimeConfigBuilder;
import org.smartparam.engine.core.ParameterValueNotFoundException;
import org.smartparam.engine.core.UndefinedLevelCreatorException;
import org.smartparam.engine.core.UnknownParameterException;
import org.smartparam.engine.core.context.LevelValues;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.decoder.ValueDecoder;
import org.smartparam.engine.core.function.Function;
import org.smartparam.engine.core.function.FunctionManager;
import org.smartparam.engine.core.index.LevelIndex;
import org.smartparam.engine.core.output.MultiValue;
import org.smartparam.engine.core.output.ParamValue;
import org.smartparam.engine.core.output.ParamValueImpl;
import org.smartparam.engine.core.prepared.InputValueNormalizer;
import org.smartparam.engine.core.prepared.ParamPreparer;
import org.smartparam.engine.core.prepared.PreparedEntry;
import org.smartparam.engine.core.prepared.PreparedLevel;
import org.smartparam.engine.core.prepared.PreparedParameter;
import org.smartparam.engine.core.type.Type;
import org.smartparam.engine.core.type.ValueHolder;
import org.smartparam.engine.ext.FunctionInvokerInterceptor;
import org.smartparam.engine.types.string.StringHolder;
import pl.decerto.hyperon.runtime.level.LevelArraySplitter;
import pl.decerto.hyperon.runtime.level.OutputLevelArraySeparator;

public class SmartParamEngine
implements ParamEngine {
    private static final Logger log = LoggerFactory.getLogger(SmartParamEngine.class);
    private static final PreparedEntry[] EMPTY_ENTRY_ARRAY = new PreparedEntry[0];
    private final ParamEngineRuntimeConfigBuilder configBuilder;
    private final ParamPreparer paramPreparer;
    private final FunctionManager functionManager;
    private final OutputLevelArraySeparator outputLevelArraySeparator;
    private FunctionInvokerInterceptor invokerInterceptor;

    public SmartParamEngine(ParamPreparer paramPreparer, FunctionManager functionManager, ParamEngineRuntimeConfigBuilder configBuilder, OutputLevelArraySeparator arraySeparator) {
        this.paramPreparer = paramPreparer;
        this.functionManager = functionManager;
        this.configBuilder = configBuilder;
        this.outputLevelArraySeparator = arraySeparator;
    }

    public void setInvokerInterceptor(FunctionInvokerInterceptor invokerInterceptor) {
        this.invokerInterceptor = invokerInterceptor;
        log.debug("enabling function invoker interceptor: {}", (Object)invokerInterceptor);
    }

    @Override
    public ParamEngineRuntimeConfig runtimeConfiguration() {
        return this.configBuilder.buildConfig();
    }

    @Override
    public ParamValue get(String paramName, ParamContext ctx) {
        log.debug("enter get[{}], ctx={}", (Object)paramName, (Object)ctx);
        PreparedParameter param = this.getPreparedParameter(paramName);
        PreparedEntry[] rows = this.findParameterEntries(param, ctx);
        if (rows.length == 0) {
            if (param.isNullable()) {
                log.debug("leave get[{}], result=null", (Object)paramName);
                return null;
            }
            throw new ParameterValueNotFoundException(paramName, ctx);
        }
        int inputLevelCount = param.getInputLevelsCount();
        int oputputLevelCount = param.getLevelCount() - inputLevelCount;
        MultiValue[] row = new MultiValue[rows.length];
        LevelArraySplitter arraySplitter = new LevelArraySplitter();
        for (int rowIndex = 0; rowIndex < rows.length; ++rowIndex) {
            PreparedEntry pe = rows[rowIndex];
            PreparedLevel[] levels = param.getLevels();
            Object[] vector = new Object[oputputLevelCount];
            for (int columnIndex = 0; columnIndex < oputputLevelCount; ++columnIndex) {
                String cellText = pe.getLevel(inputLevelCount + columnIndex + 1);
                PreparedLevel level = levels[inputLevelCount + columnIndex];
                Type<?> cellType = level.getType();
                ValueDecoder decoder = level.getDecoder();
                Object cellValue = level.isArray() ? this.decodeFromArray(arraySplitter, ctx, cellText, cellType, decoder) : decoder.decode(cellText, cellType, ctx);
                vector[columnIndex] = cellValue;
            }
            row[rowIndex] = new MultiValue(vector, param.getLevelNameMap());
        }
        ParamValueImpl result = new ParamValueImpl(row, param.getMetadata());
        log.debug("leave get[{}], result={}", (Object)paramName, (Object)result);
        return result;
    }

    private Object decodeFromArray(LevelArraySplitter arraySplitter, ParamContext ctx, String cellText, Type<?> cellType, ValueDecoder decoder) {
        LevelArraySplitter.SplitConfiguration splitConfiguration = new LevelArraySplitter.SplitConfiguration(cellType, this.outputLevelArraySeparator);
        LevelArraySplitter.DecoderConfiguration decoderConfiguration = new LevelArraySplitter.DecoderConfiguration(decoder, ctx);
        return arraySplitter.split(cellText, splitConfiguration, decoderConfiguration);
    }

    @Override
    public ParamValue get(String paramName, Object ... inputLevels) {
        LevelValues ctx = new LevelValues(inputLevels);
        return this.get(paramName, ctx);
    }

    @Override
    public Object callFunction(String functionName, Object ... args) {
        if (log.isDebugEnabled()) {
            log.debug("calling function [{}] with args: {}", (Object)functionName, (Object)this.classNames(args));
        }
        Object result = this.functionManager.invokeFunction(functionName, args);
        log.debug("function result: {}", result);
        return result;
    }

    private String[] classNames(Object ... args) {
        String[] names = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            names[i] = args[i] != null ? args[i].getClass().getSimpleName() : "null";
        }
        return names;
    }

    @Override
    public Object callEvaluatedFunction(String paramName, ParamContext ctx, Object ... args) {
        ValueHolder holder = this.get(paramName, ctx).getHolder();
        if (!(holder instanceof StringHolder)) {
            throw new InvalidFunctionToCallException(paramName, holder);
        }
        String functionName = holder.getString();
        if (functionName != null) {
            return this.callFunction(functionName, args);
        }
        return null;
    }

    void evaluateLevelValues(PreparedParameter param, ParamContext ctx) {
        PreparedLevel[] levels = param.getLevels();
        Object[] values = new Object[param.getInputLevelsCount()];
        for (int levelIndex = 0; levelIndex < values.length; ++levelIndex) {
            PreparedLevel level = levels[levelIndex];
            Function levelCreator = level.getLevelCreator();
            if (levelCreator == null) {
                throw new UndefinedLevelCreatorException(levelIndex);
            }
            String levelCreatorName = levelCreator.getName();
            log.trace("L{}: using level creator: {}", (Object)levelIndex, (Object)levelCreatorName);
            Object result = this.invokerInterceptor != null ? this.invokerInterceptor.invokeFunction(levelCreatorName, ctx, new Object[0]) : this.functionManager.invokeFunction(levelCreatorName, ctx);
            values[levelIndex] = result;
        }
        if (log.isDebugEnabled()) {
            log.debug("discovered level values: {}", (Object)Arrays.toString(values));
        }
        ctx.setLevelValues(values);
    }

    private PreparedEntry[] findParameterEntries(PreparedParameter param, String[] levelValues) {
        List<PreparedEntry> entries;
        if (param.isCacheable()) {
            LevelIndex<PreparedEntry> index = param.getIndex();
            entries = index.find(levelValues);
        } else {
            entries = this.paramPreparer.findEntries(param.getId(), levelValues);
        }
        return entries != null ? entries.toArray(new PreparedEntry[0]) : EMPTY_ENTRY_ARRAY;
    }

    private void validateLevelValues(Object[] levelValues, int parameterLevelCount) {
        if (levelValues.length != parameterLevelCount) {
            throw new InvalidLevelValuesQuery(levelValues, parameterLevelCount);
        }
    }

    private PreparedEntry[] findParameterEntries(PreparedParameter param, ParamContext ctx) {
        if (ctx.getLevelValues() == null) {
            this.evaluateLevelValues(param, ctx);
        }
        this.validateLevelValues(ctx.getLevelValues(), param.getInputLevelsCount());
        String[] normalizedInputValues = InputValueNormalizer.normalize(param, ctx.getLevelValues());
        return this.findParameterEntries(param, normalizedInputValues);
    }

    private PreparedParameter getPreparedParameter(String paramName) {
        PreparedParameter param = this.paramPreparer.getPreparedParameter(paramName);
        if (param == null) {
            throw new UnknownParameterException(paramName);
        }
        return param;
    }
}

