/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.smartparam.engine.core.function.FunctionCache;
import org.smartparam.engine.core.prepared.PreparedParamCache;
import pl.decerto.hyperon.runtime.dao.VersionJdbcDao;
import pl.decerto.hyperon.runtime.model.MpVersion;
import pl.decerto.hyperon.runtime.sync.BaseWatcher;
import pl.decerto.hyperon.runtime.sync.SyncResult;

public class VersionRuntimeWatcher
extends BaseWatcher
implements Runnable {
    private final VersionJdbcDao dao;
    private final FunctionCache functionCache;
    private final PreparedParamCache paramCache;
    private Map<Integer, MpVersion> versionMap = new HashMap<Integer, MpVersion>();
    protected Date timestamp;

    public VersionRuntimeWatcher(VersionJdbcDao dao, FunctionCache functionCache, PreparedParamCache paramCache) {
        this.dao = dao;
        this.functionCache = functionCache;
        this.paramCache = paramCache;
    }

    @Override
    public void doWatch() {
        Date lastUpdate = this.dao.getMaxLastUpdate();
        if (this.possibleModification(lastUpdate)) {
            Map<Integer, MpVersion> freshMap;
            SyncResult<MpVersion> result;
            if (this.log.isDebugEnabled()) {
                this.log.debug("newer last update: {}", (Object)this.print(lastUpdate));
            }
            if ((result = this.sync(this.versionMap, freshMap = this.dao.getAllRegionVersions())).hasAnyChanges()) {
                this.log.debug("detected version modifications: {}", result);
                this.invalidateTrackedElements(result);
            }
            this.versionMap = freshMap;
            this.timestamp = lastUpdate;
            if (this.log.isDebugEnabled()) {
                this.log.debug("last update set to: {}", (Object)this.print(this.timestamp));
            }
        }
    }

    private Set<Integer> getRegionsNeededToInvalidate(SyncResult<MpVersion> sync) {
        HashSet<Integer> regionIdSet = new HashSet<Integer>();
        for (MpVersion ver : sync.getUpdated()) {
            regionIdSet.add(ver.getRegionId());
        }
        for (MpVersion ver : sync.getCreated()) {
            regionIdSet.add(ver.getRegionId());
        }
        return regionIdSet;
    }

    private void invalidateTrackedElements(SyncResult<MpVersion> sync) {
        Set<Integer> regionIdSet = this.getRegionsNeededToInvalidate(sync);
        for (Integer regionId : regionIdSet) {
            this.log.debug("invalidating function for region: {}", (Object)regionId);
            for (String code : this.dao.getFunctionsWithRegion(regionId)) {
                this.invalidateFunction(code);
            }
            this.log.debug("invalidating parameters for region: {}", (Object)regionId);
            for (String code : this.dao.getParametersWithRegion(regionId)) {
                this.invalidateParameter(code);
            }
        }
    }

    public SyncResult<MpVersion> sync(Map<Integer, MpVersion> prevMap, Map<Integer, MpVersion> freshMap) {
        int vid;
        SyncResult<MpVersion> result = new SyncResult<MpVersion>();
        Collection<MpVersion> currList = freshMap.values();
        Collection<MpVersion> prevList = prevMap.values();
        for (MpVersion curr : currList) {
            vid = curr.getId();
            MpVersion prev = prevMap.get(vid);
            if (prev != null && !this.eq(prev, curr)) {
                result.addUpdated(curr);
            }
            if (prev != null) continue;
            result.addCreated(curr);
        }
        for (MpVersion prev : prevList) {
            vid = prev.getId();
            if (freshMap.containsKey(vid)) continue;
            result.addDeleted(prev);
        }
        return result;
    }

    private boolean eq(MpVersion v1, MpVersion v2) {
        Date d2;
        Date d1 = v1.getLastUpdate();
        return d1 == (d2 = v2.getLastUpdate()) || d1 != null && d1.equals(d2);
    }

    private void invalidateFunction(String code) {
        this.functionCache.invalidate(code);
    }

    private void invalidateParameter(String code) {
        this.paramCache.invalidate(code);
    }

    private boolean possibleModification(Date lastUpdate) {
        return lastUpdate != null && (this.timestamp == null || lastUpdate.getTime() > this.timestamp.getTime());
    }

    @Override
    protected void initWatcher() {
        this.versionMap = this.dao.getAllRegionVersions();
    }

    @Override
    protected String getWatcherName() {
        return "version-watcher";
    }
}

