/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.sync;

import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.types.date.SimpleDateFormatPool;
import pl.decerto.hyperon.runtime.sync.WatcherConfig;

public abstract class BaseWatcher
implements Runnable {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected volatile boolean running = true;
    protected WatcherConfig config = new WatcherConfig();
    private Thread watcherThread;

    void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            this.log.warn("Thread sleep was interrupted: {}", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    public void start() {
        this.log.info("starting watcher {} with configuration: {}.", (Object)this.getWatcherName(), (Object)this.config);
        this.watcherThread = new Thread((Runnable)this, this.getWatcherName());
        this.watcherThread.start();
        this.running = true;
    }

    public void stop() {
        this.log.info("stopping watcher: {}", (Object)this.getWatcherName());
        this.running = false;
        this.watcherThread.interrupt();
    }

    @Override
    public void run() {
        this.log.info("Sync watcher started.");
        this.sleep(this.config.getStartDelaySeconds());
        if (this.running) {
            this.initWatcher();
        }
        while (this.running) {
            this.watch();
            this.sleep(this.config.getWatcherPauseSeconds());
        }
        this.log.info("Sync watcher stopped.");
    }

    protected void initWatcher() {
    }

    protected void watch() {
        try {
            this.doWatch();
        }
        catch (RuntimeException e) {
            this.log.error("", (Throwable)e);
            this.sleep(this.config.getErrorPauseSeconds());
        }
    }

    protected abstract void doWatch();

    public boolean isRunning() {
        return this.running;
    }

    public void setConfig(WatcherConfig config) {
        this.config = config;
    }

    public WatcherConfig getConfig() {
        return this.config;
    }

    protected String print(Date d) {
        return d != null ? SimpleDateFormatPool.get("yyyy-MM-dd HH:mm:ss.SSS").format(d) : null;
    }

    protected abstract String getWatcherName();
}

