/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import pl.decerto.hyperon.runtime.dao.DomainCacheJdbcDao;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectImpl;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectTypeImpl;
import pl.decerto.hyperon.runtime.model.MpReferenceDto;
import pl.decerto.hyperon.runtime.model.MpRegionCached;
import pl.decerto.hyperon.runtime.profiler.attribute.AttributeKey;
import pl.decerto.hyperon.runtime.profiler.engine.AttributeEngineProfiler;

public class MpTreeDomain {
    public static final String PATH_SEPARATOR = "/";
    public static final String ELEMENT_PREFIX = "[";
    public static final String ELEMENT_SUFFIX = "]";
    private final String profile;
    private Set<MpRegionCached> cachedRegions = new HashSet<MpRegionCached>();
    private List<HyperonDomainObjectImpl> rootElements = new ArrayList<HyperonDomainObjectImpl>();
    private Map<String, HyperonDomainObjectTypeImpl> typesByCodes = new HashMap<String, HyperonDomainObjectTypeImpl>();
    private List<HyperonDomainObjectType> rootTypes = new ArrayList<HyperonDomainObjectType>();
    private Map<String, String> pathById = new HashMap<String, String>();
    private Map<String, List<String>> childrenIds = new HashMap<String, List<String>>();
    private Map<String, String> objectsCode = new HashMap<String, String>();
    private Map<String, Integer> newCopyFromId = new HashMap<String, Integer>();
    private Set<String> inconsistency = new HashSet<String>();
    private Set<String> duplicated = new HashSet<String>();

    public MpTreeDomain(String profile) {
        this.profile = profile;
    }

    public HyperonDomainObject getObjectsByPath(String path) {
        if (this.isRootPath(path)) {
            return this.processRoot();
        }
        return this.processRoot().getDomain(path);
    }

    public HyperonDomainObjectType getType(String typeCode, String collectionCode) {
        return this.typesByCodes.get(MpTreeDomain.fullTokenResolver(typeCode, collectionCode));
    }

    public static String fullTokenResolver(String typeCode, String elementCode) {
        return typeCode + ELEMENT_PREFIX + elementCode + ELEMENT_SUFFIX;
    }

    public List<HyperonDomainObjectType> getRootType() {
        return this.rootTypes;
    }

    public boolean isAnyRoot() {
        return !this.rootElements.isEmpty();
    }

    public void initObjectIdsAndPath(HyperonDomainObjectImpl domainObj) {
        this.objectsCode.put(domainObj.getId() + "", domainObj.getCode());
        if (domainObj.getParentId() == null) {
            return;
        }
        String parentId = domainObj.getParentId() + "";
        List<String> childrens = this.childrenIds.get(parentId);
        if (childrens == null) {
            childrens = new ArrayList<String>();
        }
        childrens.add(domainObj.getId() + "");
        this.childrenIds.put(parentId, childrens);
    }

    public void setRoots(List<HyperonDomainObjectImpl> roots, Map<String, HyperonDomainObjectTypeImpl> types, Map<String, List<MpReferenceDto>> parentReference, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> objectIdToAllAttributes) {
        this.typesByCodes = this.getTypesByCode(types);
        this.rootElements = new ArrayList<HyperonDomainObjectImpl>(roots);
        this.pathById.clear();
        this.cachedRegions.clear();
        this.updateElements(roots, null, objectIdToAllAttributes);
        this.processReferences(roots, parentReference, new HashSet<Integer>());
        this.findRootType();
        this.clearTempElements();
    }

    public void addInconsistency(String value) {
        this.inconsistency.add(value);
    }

    public void addDuplicated(String value) {
        this.duplicated.add(value);
    }

    private void processReferences(Collection<HyperonDomainObjectImpl> parents, Map<String, List<MpReferenceDto>> parentReference, Set<Integer> processed) {
        for (HyperonDomainObjectImpl object : parents) {
            String id = Integer.toString(object.getId());
            if (parentReference.containsKey(id)) {
                if (processed.contains(object.getId())) continue;
                processed.add(object.getId());
                List<MpReferenceDto> paths = parentReference.get(id);
                for (MpReferenceDto path : paths) {
                    HyperonDomainObject referenced = this.getObjectsByPath(path.getPath().substring(0, path.getPath().length() - 1));
                    if (referenced == null) {
                        HyperonDomainObjectTypeImpl collection = new HyperonDomainObjectTypeImpl(path.getCollectionId(), path.getParentCollectionCode(), "");
                        referenced = new HyperonDomainObjectImpl(HyperonDomainObjectImpl.getTmpId(), "!!", path.getPath(), collection, object.getId(), true);
                        ((HyperonDomainObjectImpl)referenced).setRegion(new MpRegionCached());
                    }
                    object.addReference((HyperonDomainObjectImpl)referenced, path.getParentCollectionCode());
                }
            }
            this.processReferences(object.getChildren(), parentReference, processed);
        }
    }

    private Map<String, HyperonDomainObjectTypeImpl> getTypesByCode(Map<String, HyperonDomainObjectTypeImpl> types) {
        HashMap<String, HyperonDomainObjectTypeImpl> result = new HashMap<String, HyperonDomainObjectTypeImpl>();
        for (Map.Entry<String, HyperonDomainObjectTypeImpl> type : types.entrySet()) {
            result.put(type.getValue().getFullCode(), type.getValue());
        }
        return result;
    }

    private void findRootType() {
        for (Map.Entry<String, HyperonDomainObjectTypeImpl> typeByCode : this.typesByCodes.entrySet()) {
            if (!typeByCode.getValue().isRootCollection()) continue;
            this.rootTypes.add(typeByCode.getValue());
        }
    }

    public List<String> getChildrenIds(String parentId) {
        if (this.childrenIds.get(parentId) != null) {
            return new ArrayList<String>((Collection)this.childrenIds.get(parentId));
        }
        return new ArrayList<String>();
    }

    private void updateElements(Collection<HyperonDomainObjectImpl> roots, HyperonDomainObjectImpl parent, Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> objectIdToAllAttributes) {
        for (HyperonDomainObjectImpl obj : roots) {
            obj.setParent(parent);
            this.setFullPath(obj);
            this.updateAttributeProfilerLoadTime(objectIdToAllAttributes, obj);
            this.cachedRegions.add(obj.getRegion());
            this.updateElements(obj.getChildren(), obj, objectIdToAllAttributes);
        }
    }

    private void setFullPath(HyperonDomainObjectImpl domainObj) {
        String path;
        if (domainObj.getParentId() == null) {
            path = PATH_SEPARATOR + domainObj.getFullELementCode();
        } else {
            StringBuilder parentPath = new StringBuilder(this.pathById.get(Integer.toString(domainObj.getParentId())));
            if (!StringUtils.endsWith((CharSequence)parentPath, (CharSequence)PATH_SEPARATOR)) {
                parentPath.append(PATH_SEPARATOR);
            }
            path = parentPath.append(domainObj.getFullELementCode()).toString();
        }
        domainObj.setPath(path);
        this.pathById.put(Integer.toString(domainObj.getIdToSelectChildren()), path);
        if (!domainObj.getIdToSelectChildren().equals(domainObj.getId())) {
            this.pathById.put(Integer.toString(domainObj.getId()), path);
        }
    }

    private void updateAttributeProfilerLoadTime(Map<String, List<DomainCacheJdbcDao.DomainAttributeLoadWrapper>> objectIdToAllAttributes, HyperonDomainObjectImpl obj) {
        objectIdToAllAttributes.getOrDefault(Integer.toString(obj.getId()), Collections.emptyList()).forEach(wrapper -> AttributeEngineProfiler.DOMAIN.addLoadMeasure(new AttributeKey(obj.getPath(), wrapper.getDto().getCode()), wrapper.getLoadTime().getStart(), wrapper.getLoadTime().getEnd()));
    }

    private void clearTempElements() {
        this.childrenIds.clear();
        this.objectsCode.clear();
        this.pathById.clear();
        this.newCopyFromId.clear();
    }

    public boolean isRootPath(String path) {
        return StringUtils.isBlank((CharSequence)path) || path.equals(PATH_SEPARATOR);
    }

    private HyperonDomainObject processRoot() {
        HyperonDomainObjectImpl rootObject = new HyperonDomainObjectImpl();
        rootObject.setChildren(this.rootElements);
        return rootObject;
    }

    public String toString() {
        return "MpTreeDomain [cachedRegions=" + this.cachedRegions + ", rootElements=" + this.rootElements + ELEMENT_SUFFIX;
    }

    public boolean isValid() {
        return this.inconsistency.isEmpty() && this.duplicated.isEmpty();
    }

    public void reloadRootElement(String childPath, HyperonDomainObjectImpl childNew) {
        String fullChildPath = childPath.endsWith(PATH_SEPARATOR) ? StringUtils.substringBeforeLast((String)childPath, (String)PATH_SEPARATOR) : childPath;
        Iterator<HyperonDomainObjectImpl> it = this.rootElements.iterator();
        while (it.hasNext()) {
            HyperonDomainObjectImpl element = it.next();
            String elementPath = ((HyperonDomainObjectTypeImpl)element.getCollection()).isMultiple() ? element.getPath() : element.getFullPath();
            if (!fullChildPath.equals(elementPath) && !childPath.equals(elementPath)) continue;
            it.remove();
            break;
        }
        if (childNew != null) {
            this.rootElements.add(childNew);
        }
    }

    public String getProfile() {
        return this.profile;
    }

    public boolean isChangeCopyFrom(Integer copyFrom) {
        return copyFrom != null && this.newCopyFromId.containsKey(Integer.toString(copyFrom));
    }

    public String getNewParentId(Integer copyFrom) {
        return Integer.toString(this.newCopyFromId.get(Integer.toString(copyFrom)));
    }

    public void addNewParents(Map<String, Integer> newParents) {
        this.newCopyFromId.putAll(newParents);
    }

    public Set<MpRegionCached> getCachedRegions() {
        return this.cachedRegions;
    }
}

