/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.model;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.smartparam.engine.core.context.ParamContext;
import org.smartparam.engine.core.output.ParamValue;
import pl.decerto.hyperon.runtime.core.HyperonContext;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;
import pl.decerto.hyperon.runtime.model.HyperonAttributeDefinition;
import pl.decerto.hyperon.runtime.model.HyperonDomainAttribute;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectType;
import pl.decerto.hyperon.runtime.model.HyperonDomainObjectTypeImpl;
import pl.decerto.hyperon.runtime.model.MpRegionCached;
import pl.decerto.hyperon.runtime.model.MpTreeDomain;

public class HyperonDomainObjectImpl
implements HyperonDomainObject,
Comparable<HyperonDomainObjectImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(HyperonDomainObjectImpl.class);
    private static int tmpId = 200;
    private final Integer id;
    private Integer parentId;
    private final String code;
    private final String name;
    private final HyperonDomainObjectTypeImpl collection;
    private List<HyperonDomainAttribute> dynamicAttributes;
    private Set<HyperonDomainObjectImpl> children = new TreeSet<HyperonDomainObjectImpl>();
    private List<HyperonDomainAttribute> attributes = Collections.emptyList();
    private Map<String, HyperonDomainAttribute> attrMap = Collections.emptyMap();
    private MpRegionCached region;
    private String path;
    private HyperonDomainObjectImpl parent;
    private Integer idToSelectChildren;
    private Integer sessionId;
    private boolean head;
    private Integer copyFrom;
    private Set<Integer> realChildrenIds = new TreeSet<Integer>();
    private Map<String, List<Integer>> referencesInCollections = new HashMap<String, List<Integer>>();
    private Map<String, HyperonDomainObject> childrenByToken = new HashMap<String, HyperonDomainObject>();
    private Map<String, Map<String, HyperonDomainObject>> childrenCascadeMap = new HashMap<String, Map<String, HyperonDomainObject>>();
    private Map<String, Set<HyperonDomainObject>> childrenByCollection = new HashMap<String, Set<HyperonDomainObject>>();

    public HyperonDomainObjectImpl() {
        this.id = null;
        this.code = "";
        this.name = "";
        this.collection = null;
        this.parentId = null;
    }

    public HyperonDomainObjectImpl(Integer id, String code, String name, HyperonDomainObjectTypeImpl type, Integer parentId, boolean head) {
        this.id = id;
        this.code = code;
        this.name = name;
        this.collection = type;
        this.parentId = parentId;
        this.head = head;
    }

    @Override
    public HyperonDomainObject getDomain(String objectPath) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("getDomain({}) in object {}", (Object)objectPath, (Object)this);
        }
        if (this.isRootPath(objectPath)) {
            return this;
        }
        return this.processByPath(objectPath);
    }

    private HyperonDomainObject processByPath(String objectPath) {
        String pathToProcess = objectPath.startsWith("/") ? objectPath.substring(1) : objectPath;
        String[] tokens = pathToProcess.split("/");
        if (tokens.length == 1) {
            return this.getDomainByTokenOrCollection(tokens[0]);
        }
        HyperonDomainObject child = this.childrenByToken.get(tokens[0]);
        if (child == null) {
            return null;
        }
        return ((HyperonDomainObjectImpl)child).processByPath(pathToProcess.substring(pathToProcess.indexOf(47)));
    }

    private HyperonDomainObject getDomainByTokenOrCollection(String token) {
        if (token.contains("[")) {
            HyperonDomainObject child = this.childrenByToken.get(token);
            if (child != null) {
                return child;
            }
            int bracketIx = token.indexOf(91);
            String collName = token.substring(0, bracketIx);
            String elementCode = token.substring(bracketIx + 1, token.length() - 1);
            Set<HyperonDomainObject> collectionElements = this.childrenByCollection.get(collName);
            if (collectionElements != null) {
                for (HyperonDomainObject e : collectionElements) {
                    if (!e.getCode().equals(elementCode)) continue;
                    return e;
                }
            }
        } else {
            List<HyperonDomainObject> tmpChildren = this.getChildren(token);
            if (!tmpChildren.isEmpty()) {
                return tmpChildren.get(0);
            }
        }
        return null;
    }

    @Override
    public String getCode() {
        return this.code;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public HyperonDomainObjectType getTypeCollection() {
        return this.collection;
    }

    @Override
    public boolean isRoot() {
        return this.path == null || this.isRootPath(this.path);
    }

    @Override
    public boolean isAttrDefined(String code) {
        HyperonDomainObjectType type = this.getTypeCollection();
        HyperonAttributeDefinition attrDef = null;
        if (type != null) {
            attrDef = type.getAttributeDefinition(code);
        }
        return attrDef != null;
    }

    @Override
    public HyperonDomainAttribute getAttr(String code) {
        return this.getAttribute(code);
    }

    @Override
    public String getAttrString(String code, HyperonContext ctx) {
        return this.getAttribute(code).getString(ctx);
    }

    @Override
    public BigDecimal getAttrDecimal(String code, HyperonContext ctx) {
        return this.getAttribute(code).getDecimal(ctx);
    }

    @Override
    public double getAttrNumber(String code, HyperonContext ctx) {
        return this.getAttribute(code).getNumber(ctx);
    }

    @Override
    public Integer getAttrInteger(String code, HyperonContext ctx) {
        return this.getAttribute(code).getInteger(ctx);
    }

    @Override
    public Date getAttrDate(String code, HyperonContext ctx) {
        return this.getAttribute(code).getDate(ctx);
    }

    @Override
    public boolean getAttrBoolean(String code, HyperonContext ctx) {
        return this.getAttribute(code).booleanValue(ctx);
    }

    @Override
    public String getTypeName() {
        return this.collection == null ? "" : this.collection.getTypeName();
    }

    @Override
    public String getTypeCode() {
        return this.collection == null ? "" : this.collection.getTypeCode();
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public HyperonDomainAttribute getAttribute(String code) {
        return this.attrMap.get(code);
    }

    @Override
    public List<HyperonDomainAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public HyperonDomainAttribute getDynamicAttribute(String code) {
        for (HyperonDomainAttribute attr : this.getDynamicAttributes()) {
            if (!attr.getCode().equals(code)) continue;
            return attr;
        }
        return null;
    }

    @Override
    public List<HyperonDomainAttribute> getDynamicAttributes() {
        if (this.dynamicAttributes == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(this.dynamicAttributes);
    }

    @Override
    public HyperonDomainObject getChild(String propCode, String code) {
        if (code != null) {
            return this.getChildFromMap(propCode, code);
        }
        List<HyperonDomainObject> propChildren = this.getChildren(propCode);
        if (propChildren.size() == 1) {
            return propChildren.get(0);
        }
        if (!propChildren.isEmpty() && ((HyperonDomainObjectImpl)propChildren.get((int)0)).collection.isMultiple()) {
            throw new HyperonRuntimeException(String.format("To get element from collection you have to provide elementCode: %s[null]", propCode));
        }
        return null;
    }

    private HyperonDomainObject getChildFromMap(String key1, String key2) {
        Map<String, HyperonDomainObject> sub = this.childrenCascadeMap.get(key1);
        return sub != null ? sub.get(key2) : null;
    }

    @Override
    public List<HyperonDomainObject> getChildren(String propCode) {
        Set<HyperonDomainObject> childrenTmp = this.childrenByCollection.get(propCode);
        List<Object> children2 = childrenTmp == null ? Collections.emptyList() : new ArrayList<HyperonDomainObject>(childrenTmp);
        return Collections.unmodifiableList(children2);
    }

    @Override
    public HyperonDomainObjectImpl getParent() {
        if (this.parent == null) {
            throw new HyperonRuntimeException("Parent not set - first element in the tree");
        }
        return this.parent;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    @Override
    public HyperonDomainAttribute getAttribute(String path, String attributeCode) {
        HyperonDomainObject object = this.getDomain(path);
        if (object == null) {
            return null;
        }
        return object.getAttribute(attributeCode);
    }

    @Override
    public ParamValue getAttributeValue(String path, String attributeCode, ParamContext ctx, Object ... args) {
        if (ctx == null) {
            return null;
        }
        HyperonDomainAttribute attribute = this.getAttribute(path, attributeCode);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue(ctx, args);
    }

    @Override
    public Integer getId() {
        return this.id;
    }

    @Override
    public Integer getParentId() {
        return this.parentId;
    }

    @Override
    public String getCallPath() {
        return this.getFullPath();
    }

    public void setParentId(Integer parentId) {
        this.parentId = parentId;
    }

    @Override
    public MpRegionCached getRegion() {
        return this.region;
    }

    public void setRegion(MpRegionCached region) {
        this.region = region;
    }

    public void setDynamicAttributes(List<HyperonDomainAttribute> attributes) {
        this.dynamicAttributes = attributes;
    }

    public void setChildren(List<HyperonDomainObjectImpl> children) {
        this.children = new TreeSet<HyperonDomainObjectImpl>(children);
        for (HyperonDomainObjectImpl child : children) {
            this.addChild(child);
        }
    }

    private void addChild(HyperonDomainObjectImpl child) {
        this.childrenByToken.put(MpTreeDomain.fullTokenResolver(child.getCollection().getCode(), child.getCode()), child);
        this.childCascadePut(child);
        this.addChildToCollectionMap(child.getCollection().getCode(), child);
        this.realChildrenIds.add(child.getId());
    }

    private void childCascadePut(HyperonDomainObjectImpl child) {
        this.childCascadePut(child, child.getCollection().getCode());
    }

    private void childCascadePut(HyperonDomainObjectImpl child, String referenceInCollectionCode) {
        String k2 = child.getCode();
        Map submap = this.childrenCascadeMap.computeIfAbsent(referenceInCollectionCode, k -> new HashMap());
        submap.put(k2, child);
    }

    private void childCascadeRemove(String k1, String k2) {
        Map<String, HyperonDomainObject> submap = this.childrenCascadeMap.get(k1);
        if (submap != null) {
            submap.remove(k2);
        }
    }

    private void addChildToCollectionMap(String collCode, HyperonDomainObject child) {
        Set elements = this.childrenByCollection.computeIfAbsent(collCode, k -> new TreeSet());
        elements.add(child);
    }

    public void setAttributes(List<HyperonDomainAttribute> attributes) {
        this.attributes = Collections.unmodifiableList(this.notnull(attributes));
        this.attrMap = new HashMap<String, HyperonDomainAttribute>(this.attributes.size() * 2);
        for (HyperonDomainAttribute attr : this.attributes) {
            this.attrMap.put(attr.getCode(), attr);
        }
    }

    private List<HyperonDomainAttribute> notnull(List<HyperonDomainAttribute> list) {
        if (list != null) {
            return list;
        }
        return Collections.emptyList();
    }

    public void setParent(HyperonDomainObjectImpl parent) {
        this.parent = parent;
    }

    public Integer getIdToSelectChildren() {
        return this.idToSelectChildren;
    }

    public void setIdToSelectChildren(Integer idToSelectChildren) {
        this.idToSelectChildren = idToSelectChildren;
    }

    public Integer getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(Integer sessionId) {
        this.sessionId = sessionId;
    }

    public boolean isHead() {
        return this.head;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getFullELementCode() {
        return Objects.isNull(this.collection) ? null : this.collection.getCode() + "[" + this.code + "]";
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("HyperonDomainObject[#");
        builder.append(this.id);
        builder.append(" code=");
        builder.append(this.code);
        builder.append(", name=");
        builder.append(this.name);
        builder.append(", typeId=");
        builder.append(this.collection == null ? "null" : this.collection.getId());
        builder.append(", parentId=");
        builder.append(this.parentId);
        builder.append(", path=");
        builder.append(this.path);
        if (this.copyFrom != null && this.copyFrom > 0) {
            builder.append(", copyFrom=");
            builder.append(this.copyFrom);
        }
        builder.append("]");
        return builder.toString();
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + this.code.hashCode();
        if (Objects.nonNull(this.collection)) {
            result = 31 * result + Objects.hashCode(this.collection.getCode());
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HyperonDomainObjectImpl other = (HyperonDomainObjectImpl)obj;
        EqualsBuilder equalsBuilder = new EqualsBuilder().append((Object)this.code, (Object)other.code);
        if (Objects.nonNull(this.collection)) {
            equalsBuilder.append((Object)this.collection.getCode(), other.collection == null ? null : other.collection.getCode());
        }
        return equalsBuilder.isEquals();
    }

    private boolean isRootPath(String objectPath) {
        return StringUtils.isBlank((CharSequence)objectPath) || objectPath.equals("/");
    }

    public Set<HyperonDomainObjectImpl> getChildren() {
        return this.children;
    }

    public HyperonDomainObjectType getCollection() {
        return this.getTypeCollection();
    }

    public boolean addReference(HyperonDomainObjectImpl referenced, String referenceInCollectionCode) {
        this.children.add(referenced);
        this.childrenByToken.put(MpTreeDomain.fullTokenResolver(referenced.getCollection().getCode(), referenced.getCode()), referenced);
        this.childCascadePut(referenced, referenceInCollectionCode);
        this.addChildToCollectionMap(referenceInCollectionCode, referenced);
        List<Integer> ids = this.referencesInCollections.get(referenceInCollectionCode);
        if (ids == null) {
            ids = new ArrayList<Integer>();
        }
        ids.add(referenced.id);
        this.referencesInCollections.put(referenceInCollectionCode, ids);
        return true;
    }

    public String getTypeNature() {
        return Objects.isNull(this.collection) ? null : this.collection.getTypeNature();
    }

    public String getCollectionType() {
        return Objects.isNull(this.collection) ? null : this.collection.getTypeCode();
    }

    public boolean isRealChild(Integer id) {
        return this.realChildrenIds.contains(id);
    }

    public boolean isReferenceInCollection(String collectionCode, Integer id) {
        return this.referencesInCollections.get(collectionCode) != null && this.referencesInCollections.get(collectionCode).contains(id);
    }

    @Override
    public int compareTo(HyperonDomainObjectImpl o) {
        return this.getId().compareTo(o.getId());
    }

    public static Integer getTmpId() {
        return ++tmpId * -1;
    }

    @Override
    public boolean isAttrSet(String code) {
        HyperonDomainAttribute attr = this.getAttribute(code);
        return attr != null && StringUtils.isNotBlank((CharSequence)attr.getRawValue());
    }

    public void removeChild(HyperonDomainObjectImpl child) {
        String collectionCode = child.getCollection().getCode();
        if (this.childrenByCollection.containsKey(collectionCode)) {
            this.childrenByCollection.get(collectionCode).remove(child);
        }
        String elementCode = collectionCode + '[' + child.getCode() + ']';
        this.childrenByToken.remove(elementCode);
        this.childCascadeRemove(collectionCode, child.getCode());
        this.realChildrenIds.remove(child.getId());
        if (this.referencesInCollections.get(collectionCode) != null) {
            this.referencesInCollections.get(collectionCode).remove(child.getId());
        }
        this.children.remove(child);
    }

    public void reload(HyperonDomainObject child) {
        this.addChild((HyperonDomainObjectImpl)child);
        this.children.add((HyperonDomainObjectImpl)child);
    }

    public List<HyperonDomainObjectImpl> getNotRefChildren() {
        ArrayList<HyperonDomainObjectImpl> realChildren = new ArrayList<HyperonDomainObjectImpl>();
        for (HyperonDomainObjectImpl child : this.children) {
            if (!this.realChildrenIds.contains(child.getId())) continue;
            realChildren.add(child);
        }
        return realChildren;
    }

    public void addChildren(List<HyperonDomainObjectImpl> children) {
        for (HyperonDomainObjectImpl child : children) {
            this.reload(child);
        }
    }

    public String getFullPath() {
        String normalizedPath = this.normalizePath();
        return Objects.isNull(this.collection) ? null : StringUtils.substringBeforeLast((String)normalizedPath, (String)"/") + "/" + this.collection.getCode() + "[" + this.code + "]";
    }

    private String normalizePath() {
        String normalizedPath;
        String string = normalizedPath = this.getPath() == null ? "" : this.getPath();
        if (normalizedPath.endsWith("/")) {
            normalizedPath = StringUtils.substringBeforeLast((String)normalizedPath, (String)"/");
        }
        return normalizedPath;
    }

    public Integer getCopyFrom() {
        return this.copyFrom;
    }

    public void setCopyFrom(Integer copyFrom) {
        this.copyFrom = copyFrom;
    }
}

