/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dev;

import pl.decerto.hyperon.runtime.dev.perspective.RuntimeUserView;

public class UserViewHolder {
    private final String username;
    private final RuntimeUserView userView;
    private final long timestamp;

    public UserViewHolder(String username, RuntimeUserView userView, long timestamp) {
        this.username = username;
        this.userView = userView;
        this.timestamp = timestamp;
    }

    public UserViewHolder(String username, RuntimeUserView userView) {
        this(username, userView, System.currentTimeMillis());
    }

    public String getUsername() {
        return this.username;
    }

    public RuntimeUserView getUserView() {
        return this.userView;
    }

    public boolean isExpired(long currentTimestamp, int timeToLiveSeconds) {
        return currentTimestamp > this.timestamp + (long)(1000 * timeToLiveSeconds);
    }

    public boolean isExpired(int timeToLiveSeconds) {
        return this.isExpired(System.currentTimeMillis(), timeToLiveSeconds);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("UserViewHolder[");
        sb.append("user=").append(this.username);
        sb.append(", view=").append(this.userView);
        sb.append(']');
        return sb.toString();
    }
}

