/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.dbutils.DbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.exception.EmptyResultDaoException;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.dao.util.RowCallbackHandler;
import pl.decerto.hyperon.runtime.dao.util.RowMapper;
import pl.decerto.hyperon.runtime.exception.HyperonRuntimeException;

public class MiniJdbcTemplate {
    private static final Logger LOGGER = LoggerFactory.getLogger(MiniJdbcTemplate.class);
    private DataSource dataSource;
    private ConnectionInterceptor connectionInterceptor;
    private int fetchSize = 0;

    public MiniJdbcTemplate(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        this.dataSource = dataSource;
        this.connectionInterceptor = connectionInterceptor;
    }

    public void setFetchSize(int fetchSize) {
        this.fetchSize = fetchSize;
    }

    public void query(String sql, RowCallbackHandler handler) {
        this.query(sql, handler, (Object[])null);
    }

    public void query(String sql, Object[] params, RowCallbackHandler handler) {
        this.query(sql, handler, params);
    }

    public void query(String sql, RowCallbackHandler handler, Object ... params) {
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            conn = this.connectionInterceptor.getConnection(this.dataSource);
            preparedStatement = this.prepareStatement(conn, sql, params);
            rs = preparedStatement.executeQuery();
            while (rs.next()) {
                handler.processRow(rs);
            }
        }
        catch (SQLException e) {
            try {
                throw new HyperonRuntimeException("failed to execute query", e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(null, preparedStatement, rs);
                this.connectionInterceptor.releaseConnection(conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(null, (Statement)preparedStatement, (ResultSet)rs);
        this.connectionInterceptor.releaseConnection(conn);
    }

    private PreparedStatement prepareStatement(Connection conn, String sql, Object ... params) throws SQLException {
        boolean trace = LOGGER.isTraceEnabled();
        if (trace) {
            LOGGER.trace("SQL={}", (Object)sql);
        }
        PreparedStatement preparedStatement = conn.prepareStatement(sql);
        if (this.fetchSize > 0) {
            preparedStatement.setFetchSize(this.fetchSize);
        }
        if (params != null) {
            int idx = 1;
            for (Object param : params) {
                if (param == null) {
                    preparedStatement.setNull(idx++, Integer.MIN_VALUE);
                    continue;
                }
                if (trace) {
                    LOGGER.trace("binding param: {}/{}", param.getClass(), param);
                }
                if (param instanceof String) {
                    preparedStatement.setString(idx++, (String)param);
                    continue;
                }
                if (param instanceof Integer) {
                    preparedStatement.setInt(idx++, (Integer)param);
                    continue;
                }
                if (param instanceof Long) {
                    preparedStatement.setLong(idx++, (Long)param);
                    continue;
                }
                if (param instanceof Date) {
                    preparedStatement.setDate(idx++, (Date)param);
                    continue;
                }
                preparedStatement.setObject(idx++, param);
            }
        }
        return preparedStatement;
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper) {
        return this.query(sql, rowMapper, (Object[])null);
    }

    public <T> List<T> query(String sql, Object[] params, RowMapper<T> rowMapper) {
        return this.query(sql, rowMapper, params);
    }

    public <T> List<T> query(String sql, RowMapper<T> rowMapper, Object ... params) {
        ArrayList<T> arrayList;
        ArrayList<T> result = new ArrayList<T>();
        Connection conn = null;
        PreparedStatement preparedStatement = null;
        ResultSet rs = null;
        try {
            conn = this.connectionInterceptor.getConnection(this.dataSource);
            preparedStatement = this.prepareStatement(conn, sql, params);
            rs = preparedStatement.executeQuery();
            int idx = 0;
            while (rs.next()) {
                result.add(rowMapper.mapRow(rs, idx++));
            }
            arrayList = result;
        }
        catch (SQLException e) {
            try {
                throw new HyperonRuntimeException("failed to execute query: \n" + sql, e);
            }
            catch (Throwable throwable) {
                DbUtils.closeQuietly(null, preparedStatement, rs);
                this.connectionInterceptor.releaseConnection(conn);
                throw throwable;
            }
        }
        DbUtils.closeQuietly(null, (Statement)preparedStatement, (ResultSet)rs);
        this.connectionInterceptor.releaseConnection(conn);
        return arrayList;
    }

    public <T> T queryForObject(String sql, Class<T> requiredType) {
        return this.queryForObject(sql, requiredType, null);
    }

    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... params) {
        ResultSet rs;
        PreparedStatement preparedStatement;
        Connection conn;
        block11: {
            Comparable<java.util.Date> result;
            conn = null;
            preparedStatement = null;
            rs = null;
            conn = this.connectionInterceptor.getConnection(this.dataSource);
            preparedStatement = this.prepareStatement(conn, sql, params);
            rs = preparedStatement.executeQuery();
            if (!rs.next()) break block11;
            if (requiredType == java.util.Date.class) {
                Timestamp t = rs.getTimestamp(1);
                result = t != null ? new java.util.Date(t.getTime()) : null;
            } else if (requiredType == Integer.class) {
                result = rs.getInt(1);
                if (rs.wasNull()) {
                    result = null;
                }
            } else {
                throw new HyperonRuntimeException("unsupported fieldType: " + requiredType.getName());
            }
            if (rs.next()) {
                throw new HyperonRuntimeException("Expected one result, found more");
            }
            Comparable<java.util.Date> comparable = result;
            DbUtils.closeQuietly(null, (Statement)preparedStatement, (ResultSet)rs);
            this.connectionInterceptor.releaseConnection(conn);
            return (T)comparable;
        }
        try {
            try {
                throw new EmptyResultDaoException();
            }
            catch (SQLException e) {
                throw new HyperonRuntimeException("failed to execute query: \n" + sql, e);
            }
        }
        catch (Throwable throwable) {
            DbUtils.closeQuietly(null, preparedStatement, rs);
            this.connectionInterceptor.releaseConnection(conn);
            throw throwable;
        }
    }
}

