/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.dao;

import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Calendar;
import javax.sql.DataSource;
import javax.xml.bind.DatatypeConverter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.dao.BaseDao;
import pl.decerto.hyperon.runtime.dao.util.ConnectionInterceptor;
import pl.decerto.hyperon.runtime.dao.util.RowMapper;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDetailsDto;
import pl.decerto.hyperon.runtime.license.HyperonLicenseDto;
import pl.decerto.hyperon.runtime.license.LicenseDateCalculator;
import pl.decerto.hyperon.runtime.sql.DialectRegistry;
import pl.decerto.hyperon.runtime.sql.DialectTemplate;

public class LicenseJdbcDao
extends BaseDao {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final DialectTemplate dialectTemplate = DialectRegistry.getDialectTemplate();

    public LicenseJdbcDao(DataSource dataSource, ConnectionInterceptor connectionInterceptor) {
        super(dataSource, connectionInterceptor);
    }

    public HyperonLicenseDto getValidLicense() {
        this.log.debug("enter getValidLicense");
        String sql = this.createSelectValidLicenseSQL();
        this.log.trace("using sql: {}", (Object)sql);
        HyperonLicenseDto validLicense = this.getOne(this.jdbcTemplate(1), sql, new RowMapper<HyperonLicenseDto>(){

            @Override
            public HyperonLicenseDto mapRow(ResultSet rs, int rowNum) throws SQLException {
                byte[] signature = DatatypeConverter.parseBase64Binary((String)rs.getString("signature"));
                HyperonLicenseDetailsDto.Builder detailsBuilder = new HyperonLicenseDetailsDto.Builder();
                HyperonLicenseDetailsDto licenseDetails = detailsBuilder.from(rs.getDate("validfrom")).to(rs.getDate("validto")).licenseNumber(rs.getString("licensenumber")).licensee(rs.getString("licensee")).permittedCpuCores(this.getNullableInteger(rs, "permittedcpucores")).specialConditions(rs.getString("specialconditions")).build();
                return new HyperonLicenseDto(signature, licenseDetails);
            }

            private Integer getNullableInteger(ResultSet rs, String columnName) throws SQLException {
                Integer permittedCpuCores = rs.getInt(columnName);
                return rs.wasNull() ? null : permittedCpuCores;
            }
        }, this.now());
        this.log.debug("found license:{}", (Object)validLicense);
        return validLicense;
    }

    private Date now() {
        Calendar c = Calendar.getInstance();
        c = LicenseDateCalculator.resetTime(c);
        return new Date(c.getTimeInMillis());
    }

    private String createSelectValidLicenseSQL() {
        return this.dialectTemplate.parse("select l.signature, l.validfrom, l.validto, l.licensenumber, l.licensee, l.permittedcpucores, l.specialconditions from @license l where l.validto IS NULL  OR  ? between validfrom and validto");
    }
}

