/*
 * Decompiled with CFR 0.152.
 */
package pl.decerto.hyperon.runtime.core.domain;

import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.decerto.hyperon.runtime.core.domain.DomainCache;
import pl.decerto.hyperon.runtime.core.domain.DomainCacheManager;
import pl.decerto.hyperon.runtime.core.domain.MpUserSessionProvider;
import pl.decerto.hyperon.runtime.core.versioninterceptor.EffectiveVersionConfiguration;
import pl.decerto.hyperon.runtime.model.HyperonDomainObject;

public class MpDomainCache
implements DomainCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(MpDomainCache.class);
    protected DomainCacheManager domainCacheManager;
    protected MpUserSessionProvider sessionProvider;

    @Override
    public void setup(DomainCacheManager manager) {
        this.domainCacheManager = manager;
    }

    @Override
    public void setUserSessionProvider(MpUserSessionProvider sessionProvider) {
        this.sessionProvider = sessionProvider;
    }

    @Override
    public Set<String> getProfiles() {
        LOGGER.trace("enter getProfiles()");
        return this.domainCacheManager.getProfiles();
    }

    @Override
    public HyperonDomainObject getDomain(String profileCode, String objectPath) {
        return this.getDomain(profileCode, objectPath, null);
    }

    @Override
    public HyperonDomainObject getDomain(String profileCode, String objectPath, EffectiveVersionConfiguration configuration) {
        LOGGER.trace("enter getDomain({}, {})", (Object)profileCode, (Object)objectPath);
        String profile = this.normalizeCode(profileCode);
        String path = this.normalizePath(objectPath);
        return this.getHeadOrSessionDomain(profile, path, configuration);
    }

    @Override
    public void invalidateCache() {
        this.domainCacheManager.invalidateAllCaches();
    }

    protected HyperonDomainObject getHeadOrSessionDomain(String profile, String path, EffectiveVersionConfiguration configuration) {
        if (this.sessionProvider == null || StringUtils.isBlank((CharSequence)this.sessionProvider.getUsername())) {
            return this.domainCacheManager.getByPath(profile, path, configuration);
        }
        return this.domainCacheManager.getSessionElementByPath(profile, this.sessionProvider.getUsername(), path, configuration);
    }

    protected String normalizeCode(String profile) {
        return profile != null ? profile.trim().toUpperCase() : null;
    }

    protected String normalizePath(String domainPath) {
        String path = domainPath;
        if (path != null) {
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }
}

